/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.yh.service.impl;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.project.yh.domain.YhSong;
import com.ruoyi.project.yh.domain.YhSonyhires;
import com.ruoyi.project.yh.mapper.YhSonyhiresMapper;
import com.ruoyi.project.yh.service.IYhSonyhiresService;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YhSonyhiresServiceImpl
implements IYhSonyhiresService {
    @Autowired
    private YhSonyhiresMapper yhSonyhiresMapper;

    public YhSonyhires selectYhSonyhiresByAlbumTitle(String albumTitle) {
        return this.yhSonyhiresMapper.selectYhSonyhiresByAlbumTitle(albumTitle);
    }

    public YhSonyhires selectYhSonyhiresById(String id) {
        return this.yhSonyhiresMapper.selectYhSonyhiresById(id);
    }

    public List<YhSonyhires> selectYhSonyhiresList(YhSonyhires yhSonyhires) {
        return this.yhSonyhiresMapper.selectYhSonyhiresList(yhSonyhires);
    }

    public List<YhSonyhires> selectYhSonyhiresListSearch(YhSonyhires yhSonyhires) {
        return this.yhSonyhiresMapper.selectYhSonyhiresListSearch(yhSonyhires);
    }

    public int insertYhSonyhires(YhSonyhires yhSonyhires) {
        return this.yhSonyhiresMapper.insertYhSonyhires(yhSonyhires);
    }

    public int updateYhSonyhires(YhSonyhires yhSonyhires) {
        return this.yhSonyhiresMapper.updateYhSonyhires(yhSonyhires);
    }

    public int deleteYhSonyhiresByAlbumTitles(String albumTitles) {
        return this.yhSonyhiresMapper.deleteYhSonyhiresByAlbumTitles(Convert.toStrArray((String)albumTitles));
    }

    public int deleteYhSonyhiresByAlbumTitle(String albumTitle) {
        return this.yhSonyhiresMapper.deleteYhSonyhiresByAlbumTitle(albumTitle);
    }

    public int getMaxID() {
        return this.yhSonyhiresMapper.getMaxID();
    }

    public YhSonyhires getOneByHtml(int id) throws IOException, ParseException {
        YhSonyhires yhSonyhires = new YhSonyhires();
        Document doc = Jsoup.connect((String)("http://hi-resmusic.sonyselect.kuke.com/page/album.html?id=" + id)).get();
        Element element = doc.getElementById("error");
        if (element != null) {
            yhSonyhires.setRemarks("\u9519\u8bef");
            return yhSonyhires;
        }
        String title = doc.title();
        String albumTitle = doc.getElementById("albumname").text();
        String hiRes = null;
        if (doc.getElementById("hiRes") != null) {
            hiRes = doc.getElementById("hiRes").text().replace(" |", "");
        }
        yhSonyhires.setHiRes(hiRes);
        yhSonyhires.setAlbumTitle(albumTitle);
        String format = null;
        String rate = null;
        String schools = null;
        Elements formats = doc.getElementsByClass("albumFormat");
        if (formats.size() > 0) {
            if (((Element)formats.get(0)).childNodeSize() <= 4) {
                format = ((Element)formats.get(0)).childNode(1).childNode(0).toString();
                rate = ((Element)formats.get(0)).childNode(2).childNode(0).toString();
            } else {
                format = ((Element)formats.get(0)).childNode(4).childNode(0).toString();
                rate = ((Element)formats.get(0)).childNode(5).childNodeSize() > 0 ? ((Element)formats.get(0)).childNode(5).childNode(0).toString() : "";
            }
        }
        if ((formats = doc.getElementsByClass("list-inline")).size() > 0) {
            schools = ((Element)formats.get(0)).childNode(1).childNode(0).toString();
        }
        format = format.replace(" | ", "");
        yhSonyhires.setFormat(format);
        yhSonyhires.setRate(rate);
        yhSonyhires.setSchools(schools);
        Elements elements = doc.getElementsByTag("dd");
        if (elements.size() > 3) {
            String specifications = ((Element)elements.get(0)).childNode(0).toString().replace("\n", "");
            yhSonyhires.setSpecifications(specifications);
            String release_time = ((Element)elements.get(2)).childNode(0).toString().replace("\n", "");
            yhSonyhires.setReleaseTime(DateUtils.parseDate((String)release_time, (String[])new String[]{DateUtils.YYYY_MM_DD}));
            String company = ((Element)elements.get(3)).childNode(0).toString().replace("\n", "");
            yhSonyhires.setCompany(company);
        } else {
            String release_time = ((Element)elements.get(1)).childNode(0).toString().replace("\n", "");
            yhSonyhires.setReleaseTime(DateUtils.parseDate((String)release_time, (String[])new String[]{DateUtils.YYYY_MM_DD}));
            String company = ((Element)elements.get(2)).childNode(0).toString().replace("\n", "");
            yhSonyhires.setCompany(company);
        }
        String brief_introduction = ((Element)doc.getElementsByClass("show-more-comments-space").get(0)).text();
        yhSonyhires.setBriefIntroduction(brief_introduction);
        Elements elements1 = doc.getElementsByClass("album-tr");
        String track_list = "";
        ArrayList<YhSong> yhSongList = new ArrayList<YhSong>();
        for (Element e : elements1) {
            String songNam = e.getElementById("span-track-name").text();
            String songOften = ((Element)e.getElementsByClass("trackDuration trackDurationFontSize").get(0)).text();
            YhSong song = new YhSong();
            song.setAlbumId(String.valueOf(id));
            song.setTitle(songNam);
            song.setOften(songOften);
            yhSongList.add(song);
        }
        yhSonyhires.setTrackListData(yhSongList);
        yhSonyhires.setTrackList(track_list);
        if (doc.getElementsByClass("albumIcon").size() > 0) {
            String url = ((Element)doc.getElementsByClass("albumIcon").get(0)).attr("src");
            yhSonyhires.setOriginalPictureUrl(url);
        }
        String album_artist = doc.getElementById("artist").text().replace(", ", ",");
        yhSonyhires.setAlbumArtist(album_artist);
        return yhSonyhires;
    }
}

