/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.yh.service.impl;

import com.ruoyi.project.yh.domain.MailRequest;
import com.ruoyi.project.yh.service.SendMailService;
import java.util.Date;
import org.apache.shiro.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class SendMailServiceImpl
implements SendMailService {
    @Autowired
    private JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username}")
    private String sendMailer;
    private static final Logger logger = LoggerFactory.getLogger(SendMailServiceImpl.class);

    public void checkMail(MailRequest mailRequest) {
        Assert.notNull((Object)mailRequest, (String)"\u90ae\u4ef6\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mailRequest.getSendTo(), (String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mailRequest.getSubject(), (String)"\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mailRequest.getText(), (String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void sendSimpleMail(MailRequest mailRequest) {
        SimpleMailMessage message = new SimpleMailMessage();
        this.checkMail(mailRequest);
        message.setFrom(this.sendMailer);
        message.setTo(mailRequest.getSendTo().split(","));
        message.setSubject(mailRequest.getSubject());
        message.setText(mailRequest.getText());
        message.setSentDate(new Date());
        this.javaMailSender.send(message);
        logger.info("\u53d1\u9001\u90ae\u4ef6\u6210\u529f:{}->{}", (Object)this.sendMailer, (Object)mailRequest.getSendTo());
    }
}

