/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.yh.order.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.yh.order.domain.YhMusicPackOrder;
import com.ruoyi.project.yh.order.service.IYhMusicPackOrderService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/yh/order"})
public class YhMusicPackOrderController
extends BaseController {
    private String prefix = "yh/order";
    @Autowired
    private IYhMusicPackOrderService yhMusicPackOrderService;

    @RequiresPermissions(value={"yh:order:view"})
    @GetMapping
    public String order() {
        return this.prefix + "/order";
    }

    @RequiresPermissions(value={"yh:order:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(YhMusicPackOrder yhMusicPackOrder) {
        this.startPage();
        List list = this.yhMusicPackOrderService.selectYhMusicPackOrderList(yhMusicPackOrder);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"yh:order:export"})
    @Log(title="\u97f3\u4e50\u5305\u8ba2\u5355", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(YhMusicPackOrder yhMusicPackOrder) {
        List list = this.yhMusicPackOrderService.selectYhMusicPackOrderList(yhMusicPackOrder);
        ExcelUtil util = new ExcelUtil(YhMusicPackOrder.class);
        return util.exportExcel(list, "\u97f3\u4e50\u5305\u8ba2\u5355\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"yh:order:add"})
    @Log(title="\u97f3\u4e50\u5305\u8ba2\u5355", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(YhMusicPackOrder yhMusicPackOrder) {
        return this.toAjax(this.yhMusicPackOrderService.insertYhMusicPackOrder(yhMusicPackOrder));
    }

    @GetMapping(value={"/edit/{ID}"})
    public String edit(@PathVariable(value="ID") Long ID, ModelMap mmap) {
        YhMusicPackOrder yhMusicPackOrder = this.yhMusicPackOrderService.selectYhMusicPackOrderByID(ID);
        mmap.put((Object)"yhMusicPackOrder", (Object)yhMusicPackOrder);
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"yh:order:edit"})
    @Log(title="\u97f3\u4e50\u5305\u8ba2\u5355", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(YhMusicPackOrder yhMusicPackOrder) {
        return this.toAjax(this.yhMusicPackOrderService.updateYhMusicPackOrder(yhMusicPackOrder));
    }

    @RequiresPermissions(value={"yh:order:remove"})
    @Log(title="\u97f3\u4e50\u5305\u8ba2\u5355", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.yhMusicPackOrderService.deleteYhMusicPackOrderByIDs(ids));
    }
}

