/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.yh.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.yh.domain.YhSonyhires;
import com.ruoyi.project.yh.service.IYhSonyhiresService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/yh/sonyHires"})
public class YhSonyhiresController
extends BaseController {
    private String prefix = "yh/sonyHires";
    @Autowired
    private IYhSonyhiresService yhSonyhiresService;

    @RequiresPermissions(value={"yh:sonyHires:view"})
    @GetMapping
    public String sonyHires() {
        return this.prefix + "/sonyHires";
    }

    @RequiresPermissions(value={"yh:sonyHires:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(YhSonyhires yhSonyhires) {
        this.startPage();
        List list = this.yhSonyhiresService.selectYhSonyhiresList(yhSonyhires);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"yh:sonyHires:export"})
    @Log(title="\u7d22\u5c3c\u7cbe\u9009\u4e13\u8f91\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(YhSonyhires yhSonyhires) {
        List list = this.yhSonyhiresService.selectYhSonyhiresList(yhSonyhires);
        ExcelUtil util = new ExcelUtil(YhSonyhires.class);
        return util.exportExcel(list, "\u7d22\u5c3c\u7cbe\u9009\u4e13\u8f91\u4fe1\u606f\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @GetMapping(value={"/listTable"})
    public String listTable() {
        return this.prefix + "/listTable";
    }

    @RequiresPermissions(value={"yh:sonyHires:add"})
    @Log(title="\u7d22\u5c3c\u7cbe\u9009\u4e13\u8f91\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(YhSonyhires yhSonyhires) {
        return this.toAjax(this.yhSonyhiresService.insertYhSonyhires(yhSonyhires));
    }

    @GetMapping(value={"/edit/{albumTitle}"})
    public String edit(@PathVariable(value="albumTitle") String albumTitle, ModelMap mmap) {
        YhSonyhires yhSonyhires = this.yhSonyhiresService.selectYhSonyhiresByAlbumTitle(albumTitle);
        mmap.put((Object)"yhSonyhires", (Object)yhSonyhires);
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"yh:sonyHires:edit"})
    @Log(title="\u7d22\u5c3c\u7cbe\u9009\u4e13\u8f91\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(YhSonyhires yhSonyhires) {
        return this.toAjax(this.yhSonyhiresService.updateYhSonyhires(yhSonyhires));
    }

    @RequiresPermissions(value={"yh:sonyHires:remove"})
    @Log(title="\u7d22\u5c3c\u7cbe\u9009\u4e13\u8f91\u4fe1\u606f", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.yhSonyhiresService.deleteYhSonyhiresByAlbumTitles(ids));
    }
}

