/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.tool.swagger;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.project.tool.swagger.UserEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7528\u6237\u4fe1\u606f\u7ba1\u7406")
@RestController
@RequestMapping(value={"/test/user"})
public class TestController
extends BaseController {
    private static final Map<Integer, UserEntity> users = new LinkedHashMap();

    public TestController() {
        users.put(1, new UserEntity(Integer.valueOf(1), "admin", "admin123", "15888888888"));
        users.put(2, new UserEntity(Integer.valueOf(2), "ry", "admin123", "15666666666"));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/list"})
    public AjaxResult userList() {
        ArrayList userList = new ArrayList(users.values());
        return AjaxResult.success(userList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8be6\u7ec6")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path")
    @GetMapping(value={"/{userId}"})
    public AjaxResult getUser(@PathVariable Integer userId) {
        if (!users.isEmpty() && users.containsKey(userId)) {
            return AjaxResult.success(users.get(userId));
        }
        return this.error("\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="Integer"), @ApiImplicitParam(name="username", value="\u7528\u6237\u540d\u79f0", dataType="String"), @ApiImplicitParam(name="password", value="\u7528\u6237\u5bc6\u7801", dataType="String"), @ApiImplicitParam(name="mobile", value="\u7528\u6237\u624b\u673a", dataType="String")})
    @PostMapping(value={"/save"})
    public AjaxResult save(UserEntity user) {
        if (StringUtils.isNull((Object)user) || StringUtils.isNull((Object)user.getUserId())) {
            return this.error("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return AjaxResult.success((Object)users.put(user.getUserId(), user));
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237")
    @PutMapping(value={"/update"})
    public AjaxResult update(@RequestBody UserEntity user) {
        if (StringUtils.isNull((Object)user) || StringUtils.isNull((Object)user.getUserId())) {
            return this.error("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (users.isEmpty() || !users.containsKey(user.getUserId())) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        users.remove(user.getUserId());
        return AjaxResult.success((Object)users.put(user.getUserId(), user));
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path")
    @DeleteMapping(value={"/{userId}"})
    public AjaxResult delete(@PathVariable Integer userId) {
        if (!users.isEmpty() && users.containsKey(userId)) {
            users.remove(userId);
            return this.success();
        }
        return this.error("\u7528\u6237\u4e0d\u5b58\u5728");
    }
}

