/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.tool.gen.util;

import com.alibaba.fastjson.JSONObject;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.project.tool.gen.domain.GenTable;
import com.ruoyi.project.tool.gen.domain.GenTableColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class VelocityUtils {
    private static final String PROJECT_PATH = "main/java";
    private static final String MYBATIS_PATH = "main/resources/mybatis";
    private static final String TEMPLATES_PATH = "main/resources/templates";
    private static final String DEFAULT_PARENT_MENU_ID = "3";

    public static VelocityContext prepareContext(GenTable genTable) {
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", (Object)genTable.getTplCategory());
        velocityContext.put("tableName", (Object)genTable.getTableName());
        velocityContext.put("functionName", (Object)(StringUtils.isNotEmpty((String)functionName) ? functionName : "\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011"));
        velocityContext.put("ClassName", (Object)genTable.getClassName());
        velocityContext.put("className", (Object)StringUtils.uncapitalize((String)genTable.getClassName()));
        velocityContext.put("moduleName", (Object)genTable.getModuleName());
        velocityContext.put("businessName", (Object)genTable.getBusinessName());
        velocityContext.put("basePackage", (Object)VelocityUtils.getPackagePrefix((String)packageName));
        velocityContext.put("packageName", (Object)packageName);
        velocityContext.put("author", (Object)genTable.getFunctionAuthor());
        velocityContext.put("datetime", (Object)DateUtils.getDate());
        velocityContext.put("pkColumn", (Object)genTable.getPkColumn());
        velocityContext.put("importList", (Object)VelocityUtils.getImportList((GenTable)genTable));
        velocityContext.put("permissionPrefix", (Object)VelocityUtils.getPermissionPrefix((String)moduleName, (String)businessName));
        velocityContext.put("columns", (Object)genTable.getColumns());
        velocityContext.put("table", (Object)genTable);
        VelocityUtils.setMenuVelocityContext((VelocityContext)velocityContext, (GenTable)genTable);
        if ("tree".equals(tplCategory)) {
            VelocityUtils.setTreeVelocityContext((VelocityContext)velocityContext, (GenTable)genTable);
        }
        if ("sub".equals(tplCategory)) {
            VelocityUtils.setSubVelocityContext((VelocityContext)velocityContext, (GenTable)genTable);
        }
        return velocityContext;
    }

    public static void setMenuVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String parentMenuId = VelocityUtils.getParentMenuId((JSONObject)paramsObj);
        context.put("parentMenuId", (Object)parentMenuId);
    }

    public static void setTreeVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String treeCode = VelocityUtils.getTreecode((JSONObject)paramsObj);
        String treeParentCode = VelocityUtils.getTreeParentCode((JSONObject)paramsObj);
        String treeName = VelocityUtils.getTreeName((JSONObject)paramsObj);
        context.put("treeCode", (Object)treeCode);
        context.put("treeParentCode", (Object)treeParentCode);
        context.put("treeName", (Object)treeName);
        context.put("expandColumn", (Object)VelocityUtils.getExpandColumn((GenTable)genTable));
        if (paramsObj.containsKey((Object)"treeParentCode")) {
            context.put("tree_parent_code", (Object)paramsObj.getString("treeParentCode"));
        }
        if (paramsObj.containsKey((Object)"treeName")) {
            context.put("tree_name", (Object)paramsObj.getString("treeName"));
        }
    }

    public static void setSubVelocityContext(VelocityContext context, GenTable genTable) {
        GenTable subTable = genTable.getSubTable();
        String subTableName = genTable.getSubTableName();
        String subTableFkName = genTable.getSubTableFkName();
        String subClassName = genTable.getSubTable().getClassName();
        String subTableFkClassName = StringUtils.convertToCamelCase((String)subTableFkName);
        context.put("subTable", (Object)subTable);
        context.put("subTableName", (Object)subTableName);
        context.put("subTableFkName", (Object)subTableFkName);
        context.put("subTableFkClassName", (Object)subTableFkClassName);
        context.put("subTableFkclassName", (Object)StringUtils.uncapitalize((String)subTableFkClassName));
        context.put("subClassName", (Object)subClassName);
        context.put("subclassName", (Object)StringUtils.uncapitalize((String)subClassName));
        context.put("subImportList", (Object)VelocityUtils.getImportList((GenTable)genTable.getSubTable()));
    }

    public static List<String> getTemplateList(String tplCategory) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("vm/java/domain.java.vm");
        templates.add("vm/java/mapper.java.vm");
        templates.add("vm/java/service.java.vm");
        templates.add("vm/java/serviceImpl.java.vm");
        templates.add("vm/java/controller.java.vm");
        templates.add("vm/xml/mapper.xml.vm");
        if ("crud".equals(tplCategory)) {
            templates.add("vm/html/list.html.vm");
        } else if ("tree".equals(tplCategory)) {
            templates.add("vm/html/tree.html.vm");
            templates.add("vm/html/list-tree.html.vm");
        } else if ("sub".equals(tplCategory)) {
            templates.add("vm/html/list.html.vm");
            templates.add("vm/java/sub-domain.java.vm");
        }
        templates.add("vm/html/add.html.vm");
        templates.add("vm/html/edit.html.vm");
        templates.add("vm/sql/sql.vm");
        return templates;
    }

    public static String getFileName(String template, GenTable genTable) {
        String fileName = "";
        String packageName = genTable.getPackageName();
        String moduleName = genTable.getModuleName();
        String className = genTable.getClassName();
        String businessName = genTable.getBusinessName();
        String javaPath = "main/java/" + StringUtils.replace((String)packageName, (String)".", (String)"/");
        String mybatisPath = "main/resources/mybatis/" + moduleName;
        String htmlPath = "main/resources/templates/" + moduleName + "/" + businessName;
        if (template.contains("domain.java.vm")) {
            fileName = StringUtils.format((String)"{}/{}/domain/{}.java", (Object[])new Object[]{javaPath, businessName, className});
        }
        if (template.contains("sub-domain.java.vm") && StringUtils.equals((CharSequence)"sub", (CharSequence)genTable.getTplCategory())) {
            fileName = StringUtils.format((String)"{}/{}/domain/{}.java", (Object[])new Object[]{javaPath, businessName, genTable.getSubTable().getClassName()});
        } else if (template.contains("mapper.java.vm")) {
            fileName = StringUtils.format((String)"{}/{}/mapper/{}Mapper.java", (Object[])new Object[]{javaPath, businessName, className});
        } else if (template.contains("service.java.vm")) {
            fileName = StringUtils.format((String)"{}/{}/service/I{}Service.java", (Object[])new Object[]{javaPath, businessName, className});
        } else if (template.contains("serviceImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/{}/service/impl/{}ServiceImpl.java", (Object[])new Object[]{javaPath, businessName, className});
        } else if (template.contains("controller.java.vm")) {
            fileName = StringUtils.format((String)"{}/{}/controller/{}Controller.java", (Object[])new Object[]{javaPath, businessName, className});
        } else if (template.contains("mapper.xml.vm")) {
            fileName = StringUtils.format((String)"{}/{}Mapper.xml", (Object[])new Object[]{mybatisPath, className});
        } else if (template.contains("list.html.vm")) {
            fileName = StringUtils.format((String)"{}/{}.html", (Object[])new Object[]{htmlPath, businessName});
        } else if (template.contains("list-tree.html.vm")) {
            fileName = StringUtils.format((String)"{}/{}.html", (Object[])new Object[]{htmlPath, businessName});
        } else if (template.contains("tree.html.vm")) {
            fileName = StringUtils.format((String)"{}/tree.html", (Object[])new Object[]{htmlPath});
        } else if (template.contains("add.html.vm")) {
            fileName = StringUtils.format((String)"{}/add.html", (Object[])new Object[]{htmlPath});
        } else if (template.contains("edit.html.vm")) {
            fileName = StringUtils.format((String)"{}/edit.html", (Object[])new Object[]{htmlPath});
        } else if (template.contains("sql.vm")) {
            fileName = businessName + "Menu.sql";
        }
        return fileName;
    }

    public static String getPackagePrefix(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringUtils.substring((String)packageName, (int)0, (int)lastIndex);
        return basePackage;
    }

    public static HashSet<String> getImportList(GenTable genTable) {
        List columns = genTable.getColumns();
        GenTable subGenTable = genTable.getSubTable();
        HashSet<String> importList = new HashSet<String>();
        if (StringUtils.isNotNull((Object)subGenTable)) {
            importList.add("java.util.List");
        }
        for (GenTableColumn column : columns) {
            if (!column.isSuperColumn() && "Date".equals(column.getJavaType())) {
                importList.add("java.util.Date");
                importList.add("com.fasterxml.jackson.annotation.JsonFormat");
                continue;
            }
            if (column.isSuperColumn() || !"BigDecimal".equals(column.getJavaType())) continue;
            importList.add("java.math.BigDecimal");
        }
        return importList;
    }

    public static String getPermissionPrefix(String moduleName, String businessName) {
        return StringUtils.format((String)"{}:{}", (Object[])new Object[]{moduleName, businessName});
    }

    public static String getParentMenuId(JSONObject paramsObj) {
        if (StringUtils.isNotEmpty((Map)paramsObj) && paramsObj.containsKey((Object)"parentMenuId") && StringUtils.isNotEmpty((String)paramsObj.getString("parentMenuId"))) {
            return paramsObj.getString("parentMenuId");
        }
        return "3";
    }

    public static String getTreecode(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeCode")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeCode"));
        }
        return "";
    }

    public static String getTreeParentCode(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeParentCode")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeParentCode"));
        }
        return "";
    }

    public static String getTreeName(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeName")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeName"));
        }
        return "";
    }

    public static int getExpandColumn(GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String treeName = paramsObj.getString("treeName");
        int num = 0;
        for (GenTableColumn column : genTable.getColumns()) {
            if (!column.isList()) continue;
            ++num;
            String columnName = column.getColumnName();
            if (!columnName.equals(treeName)) continue;
            break;
        }
        return num;
    }
}

