/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.tool.gen.util;

import com.ruoyi.common.constant.GenConstants;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.config.GenConfig;
import com.ruoyi.project.tool.gen.domain.GenTable;
import com.ruoyi.project.tool.gen.domain.GenTableColumn;
import java.util.Arrays;
import org.apache.commons.lang3.RegExUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenUtils {
    public static void initTable(GenTable genTable, String operName) {
        genTable.setClassName(GenUtils.convertClassName((String)genTable.getTableName()));
        genTable.setPackageName(GenConfig.getPackageName());
        genTable.setModuleName(GenUtils.getModuleName((String)GenConfig.getPackageName()));
        genTable.setBusinessName(GenUtils.getBusinessName((String)genTable.getTableName()));
        genTable.setFunctionName(GenUtils.replaceText((String)genTable.getTableComment()));
        genTable.setFunctionAuthor(GenConfig.getAuthor());
        genTable.setCreateBy(operName);
    }

    public static void initColumnField(GenTableColumn column, GenTable table) {
        String dataType = GenUtils.getDbType((String)column.getColumnType());
        String columnName = column.getColumnName();
        column.setTableId(table.getTableId());
        column.setCreateBy(table.getCreateBy());
        column.setJavaField(StringUtils.toCamelCase((String)columnName));
        column.setJavaType("String");
        if (GenUtils.arraysContains((String[])GenConstants.COLUMNTYPE_STR, (String)dataType) || GenUtils.arraysContains((String[])GenConstants.COLUMNTYPE_TEXT, (String)dataType)) {
            Integer columnLength = GenUtils.getColumnLength((String)column.getColumnType());
            String htmlType = columnLength >= 500 || GenUtils.arraysContains((String[])GenConstants.COLUMNTYPE_TEXT, (String)dataType) ? "textarea" : "input";
            column.setHtmlType(htmlType);
        } else if (GenUtils.arraysContains((String[])GenConstants.COLUMNTYPE_TIME, (String)dataType)) {
            column.setJavaType("Date");
            column.setHtmlType("datetime");
        } else if (GenUtils.arraysContains((String[])GenConstants.COLUMNTYPE_NUMBER, (String)dataType)) {
            column.setHtmlType("input");
            String[] str = StringUtils.split((String)StringUtils.substringBetween((String)column.getColumnType(), (String)"(", (String)")"), (String)",");
            if (str != null && str.length == 2 && Integer.parseInt(str[1]) > 0) {
                column.setJavaType("BigDecimal");
            } else if (str != null && str.length == 1 && Integer.parseInt(str[0]) <= 10) {
                column.setJavaType("Integer");
            } else {
                column.setJavaType("Long");
            }
        }
        column.setIsInsert("1");
        if (!GenUtils.arraysContains((String[])GenConstants.COLUMNNAME_NOT_EDIT, (String)columnName) && !column.isPk()) {
            column.setIsEdit("1");
        }
        if (!GenUtils.arraysContains((String[])GenConstants.COLUMNNAME_NOT_LIST, (String)columnName) && !column.isPk()) {
            column.setIsList("1");
        }
        if (!GenUtils.arraysContains((String[])GenConstants.COLUMNNAME_NOT_QUERY, (String)columnName) && !column.isPk()) {
            column.setIsQuery("1");
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"name")) {
            column.setQueryType("LIKE");
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"status")) {
            column.setHtmlType("radio");
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"type") || StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"sex")) {
            column.setHtmlType("select");
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"file")) {
            column.setHtmlType("upload");
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"content")) {
            column.setHtmlType("summernote");
        }
    }

    public static boolean arraysContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static String getModuleName(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        int nameLength = packageName.length();
        String moduleName = StringUtils.substring((String)packageName, (int)(lastIndex + 1), (int)nameLength);
        return moduleName;
    }

    public static String getBusinessName(String tableName) {
        int lastIndex = tableName.lastIndexOf("_");
        int nameLength = tableName.length();
        String businessName = StringUtils.substring((String)tableName, (int)(lastIndex + 1), (int)nameLength);
        return businessName;
    }

    public static String convertClassName(String tableName) {
        boolean autoRemovePre = GenConfig.getAutoRemovePre();
        String tablePrefix = GenConfig.getTablePrefix();
        if (autoRemovePre && StringUtils.isNotEmpty((String)tablePrefix)) {
            String[] searchList = StringUtils.split((String)tablePrefix, (String)",");
            tableName = GenUtils.replaceFirst((String)tableName, (String[])searchList);
        }
        return StringUtils.convertToCamelCase((String)tableName);
    }

    public static String replaceFirst(String replacementm, String[] searchList) {
        String text = replacementm;
        for (String searchString : searchList) {
            if (!replacementm.startsWith(searchString)) continue;
            text = replacementm.replaceFirst(searchString, "");
            break;
        }
        return text;
    }

    public static String replaceText(String text) {
        return RegExUtils.replaceAll((String)text, (String)"(?:\u8868|\u82e5\u4f9d)", (String)"");
    }

    public static String getDbType(String columnType) {
        if (StringUtils.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            return StringUtils.substringBefore((String)columnType, (String)"(");
        }
        return columnType;
    }

    public static Integer getColumnLength(String columnType) {
        if (StringUtils.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            String length = StringUtils.substringBetween((String)columnType, (String)"(", (String)")");
            return Integer.valueOf(length);
        }
        return 0;
    }
}

