/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.tool.gen.controller;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.domain.CxSelect;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.tool.gen.domain.GenTable;
import com.ruoyi.project.tool.gen.domain.GenTableColumn;
import com.ruoyi.project.tool.gen.service.IGenTableColumnService;
import com.ruoyi.project.tool.gen.service.IGenTableService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tool/gen"})
public class GenController
extends BaseController {
    private String prefix = "tool/gen";
    @Autowired
    private IGenTableService genTableService;
    @Autowired
    private IGenTableColumnService genTableColumnService;

    @RequiresPermissions(value={"tool:gen:view"})
    @GetMapping
    public String gen() {
        return this.prefix + "/gen";
    }

    @RequiresPermissions(value={"tool:gen:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo genList(GenTable genTable) {
        this.startPage();
        List list = this.genTableService.selectGenTableList(genTable);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"tool:gen:list"})
    @PostMapping(value={"/db/list"})
    @ResponseBody
    public TableDataInfo dataList(GenTable genTable) {
        this.startPage();
        List list = this.genTableService.selectDbTableList(genTable);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"tool:gen:list"})
    @PostMapping(value={"/column/list"})
    @ResponseBody
    public TableDataInfo columnList(GenTableColumn genTableColumn) {
        TableDataInfo dataInfo = new TableDataInfo();
        List list = this.genTableColumnService.selectGenTableColumnListByTableId(genTableColumn);
        dataInfo.setRows(list);
        dataInfo.setTotal((long)list.size());
        return dataInfo;
    }

    @RequiresPermissions(value={"tool:gen:list"})
    @GetMapping(value={"/importTable"})
    public String importTable() {
        return this.prefix + "/importTable";
    }

    @RequiresPermissions(value={"tool:gen:list"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importTable"})
    @ResponseBody
    public AjaxResult importTableSave(String tables) {
        String[] tableNames = Convert.toStrArray((String)tables);
        List tableList = this.genTableService.selectDbTableListByNames(tableNames);
        this.genTableService.importGenTable(tableList);
        return AjaxResult.success();
    }

    @GetMapping(value={"/edit/{tableId}"})
    public String edit(@PathVariable(value="tableId") Long tableId, ModelMap mmap) {
        GenTable table = this.genTableService.selectGenTableById(tableId);
        List genTables = this.genTableService.selectGenTableAll();
        ArrayList<CxSelect> cxSelect = new ArrayList<CxSelect>();
        for (GenTable genTable : genTables) {
            if (StringUtils.equals((CharSequence)table.getTableName(), (CharSequence)genTable.getTableName())) continue;
            CxSelect cxTable = new CxSelect(genTable.getTableName(), genTable.getTableName() + '\uff1a' + genTable.getTableComment());
            ArrayList<CxSelect> cxColumns = new ArrayList<CxSelect>();
            for (GenTableColumn tableColumn : genTable.getColumns()) {
                cxColumns.add(new CxSelect(tableColumn.getColumnName(), tableColumn.getColumnName() + '\uff1a' + tableColumn.getColumnComment()));
            }
            cxTable.setS(cxColumns);
            cxSelect.add(cxTable);
        }
        mmap.put((Object)"table", (Object)table);
        mmap.put((Object)"data", JSON.toJSON(cxSelect));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"tool:gen:edit"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated GenTable genTable) {
        this.genTableService.validateEdit(genTable);
        this.genTableService.updateGenTable(genTable);
        return AjaxResult.success();
    }

    @RequiresPermissions(value={"tool:gen:remove"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        this.genTableService.deleteGenTableByIds(ids);
        return AjaxResult.success();
    }

    @RequiresPermissions(value={"tool:gen:preview"})
    @GetMapping(value={"/preview/{tableId}"})
    @ResponseBody
    public AjaxResult preview(@PathVariable(value="tableId") Long tableId) throws IOException {
        Map dataMap = this.genTableService.previewCode(tableId);
        return AjaxResult.success((Object)dataMap);
    }

    @RequiresPermissions(value={"tool:gen:code"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.GENCODE)
    @GetMapping(value={"/download/{tableName}"})
    public void download(HttpServletResponse response, @PathVariable(value="tableName") String tableName) throws IOException {
        byte[] data = this.genTableService.downloadCode(tableName);
        this.genCode(response, data);
    }

    @RequiresPermissions(value={"tool:gen:code"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.GENCODE)
    @GetMapping(value={"/genCode/{tableName}"})
    @ResponseBody
    public AjaxResult genCode(@PathVariable(value="tableName") String tableName) {
        this.genTableService.generatorCode(tableName);
        return AjaxResult.success();
    }

    @RequiresPermissions(value={"tool:gen:edit"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.UPDATE)
    @GetMapping(value={"/synchDb/{tableName}"})
    @ResponseBody
    public AjaxResult synchDb(@PathVariable(value="tableName") String tableName) {
        this.genTableService.synchDb(tableName);
        return AjaxResult.success();
    }

    @RequiresPermissions(value={"tool:gen:code"})
    @Log(title="\u4ee3\u7801\u751f\u6210", businessType=BusinessType.GENCODE)
    @GetMapping(value={"/batchGenCode"})
    @ResponseBody
    public void batchGenCode(HttpServletResponse response, String tables) throws IOException {
        String[] tableNames = Convert.toStrArray((String)tables);
        byte[] data = this.genTableService.downloadCode(tableNames);
        this.genCode(response, data);
    }

    private void genCode(HttpServletResponse response, byte[] data) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"ruoyi.zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }
}

