/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.user.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.aspectj.lang.annotation.DataScope;
import com.ruoyi.framework.shiro.service.PasswordService;
import com.ruoyi.project.system.config.service.IConfigService;
import com.ruoyi.project.system.post.domain.Post;
import com.ruoyi.project.system.post.mapper.PostMapper;
import com.ruoyi.project.system.role.domain.Role;
import com.ruoyi.project.system.role.mapper.RoleMapper;
import com.ruoyi.project.system.user.domain.User;
import com.ruoyi.project.system.user.domain.UserPost;
import com.ruoyi.project.system.user.domain.UserRole;
import com.ruoyi.project.system.user.mapper.UserMapper;
import com.ruoyi.project.system.user.mapper.UserPostMapper;
import com.ruoyi.project.system.user.mapper.UserRoleMapper;
import com.ruoyi.project.system.user.service.IUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private PostMapper postMapper;
    @Autowired
    private UserPostMapper userPostMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IConfigService configService;
    @Autowired
    private PasswordService passwordService;

    @DataScope(deptAlias="d", userAlias="u")
    public List<User> selectUserList(User user) {
        return this.userMapper.selectUserList(user);
    }

    @DataScope(deptAlias="d", userAlias="u")
    public List<User> selectAllocatedList(User user) {
        return this.userMapper.selectAllocatedList(user);
    }

    @DataScope(deptAlias="d", userAlias="u")
    public List<User> selectUnallocatedList(User user) {
        return this.userMapper.selectUnallocatedList(user);
    }

    public User selectUserByLoginName(String userName) {
        return this.userMapper.selectUserByLoginName(userName);
    }

    public User selectUserByPhoneNumber(String phoneNumber) {
        return this.userMapper.selectUserByPhoneNumber(phoneNumber);
    }

    public User selectUserByEmail(String email) {
        return this.userMapper.selectUserByEmail(email);
    }

    public User selectUserById(Long userId) {
        return this.userMapper.selectUserById(userId);
    }

    public List<UserRole> selectUserRoleByUserId(Long userId) {
        return this.userRoleMapper.selectUserRoleByUserId(userId);
    }

    @Transactional
    public int deleteUserById(Long userId) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.userPostMapper.deleteUserPostByUserId(userId);
        return this.userMapper.deleteUserById(userId);
    }

    @Transactional
    public int deleteUserByIds(String ids) {
        Long[] userIds;
        for (Long userId : userIds = Convert.toLongArray((String)ids)) {
            this.checkUserAllowed(new User(userId));
        }
        this.userRoleMapper.deleteUserRole(userIds);
        this.userPostMapper.deleteUserPost(userIds);
        return this.userMapper.deleteUserByIds(userIds);
    }

    @Transactional
    public int insertUser(User user) {
        user.randomSalt();
        user.setPassword(this.passwordService.encryptPassword(user.getLoginName(), user.getPassword(), user.getSalt()));
        user.setCreateBy(ShiroUtils.getLoginName());
        int rows = this.userMapper.insertUser(user);
        this.insertUserPost(user);
        this.insertUserRole(user.getUserId(), user.getRoleIds());
        return rows;
    }

    public boolean registerUser(User user) {
        user.setUserType("01");
        user.randomSalt();
        user.setPassword(this.passwordService.encryptPassword(user.getLoginName(), user.getPassword(), user.getSalt()));
        return this.userMapper.insertUser(user) > 0;
    }

    @Transactional
    public int updateUser(User user) {
        Long userId = user.getUserId();
        user.setUpdateBy(ShiroUtils.getLoginName());
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(user.getUserId(), user.getRoleIds());
        this.userPostMapper.deleteUserPostByUserId(userId);
        this.insertUserPost(user);
        return this.userMapper.updateUser(user);
    }

    public int updateUserInfo(User user) {
        return this.userMapper.updateUser(user);
    }

    @Transactional
    public void insertUserAuth(Long userId, Long[] roleIds) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(userId, roleIds);
    }

    public int resetUserPwd(User user) {
        user.randomSalt();
        user.setPassword(this.passwordService.encryptPassword(user.getLoginName(), user.getPassword(), user.getSalt()));
        return this.updateUserInfo(user);
    }

    public void insertUserRole(Long userId, Long[] roleIds) {
        if (StringUtils.isNotNull((Object)roleIds)) {
            ArrayList<UserRole> list = new ArrayList<UserRole>();
            for (Long roleId : roleIds) {
                UserRole ur = new UserRole();
                ur.setUserId(userId);
                ur.setRoleId(roleId);
                list.add(ur);
            }
            if (list.size() > 0) {
                this.userRoleMapper.batchUserRole(list);
            }
        }
    }

    public void insertUserPost(User user) {
        Long[] posts = user.getPostIds();
        if (StringUtils.isNotNull((Object)posts)) {
            ArrayList<UserPost> list = new ArrayList<UserPost>();
            for (Long postId : user.getPostIds()) {
                UserPost up = new UserPost();
                up.setUserId(user.getUserId());
                up.setPostId(postId);
                list.add(up);
            }
            if (list.size() > 0) {
                this.userPostMapper.batchUserPost(list);
            }
        }
    }

    public String checkLoginNameUnique(String loginName) {
        int count = this.userMapper.checkLoginNameUnique(loginName);
        if (count > 0) {
            return "1";
        }
        return "0";
    }

    public String checkPhoneUnique(User user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        User info = this.userMapper.checkPhoneUnique(user.getPhonenumber());
        if (StringUtils.isNotNull((Object)info) && info.getUserId().longValue() != userId.longValue()) {
            return "1";
        }
        return "0";
    }

    public String checkEmailUnique(User user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        User info = this.userMapper.checkEmailUnique(user.getEmail());
        if (StringUtils.isNotNull((Object)info) && info.getUserId().longValue() != userId.longValue()) {
            return "1";
        }
        return "0";
    }

    public void checkUserAllowed(User user) {
        if (StringUtils.isNotNull((Object)user.getUserId()) && user.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        }
    }

    public void checkUserDataScope(Long userId) {
        if (!User.isAdmin((Long)ShiroUtils.getUserId())) {
            User user = new User();
            user.setUserId(userId);
            List users = ((UserServiceImpl)SpringUtils.getAopProxy((Object)this)).selectUserList(user);
            if (StringUtils.isEmpty((Collection)users)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7528\u6237\u6570\u636e\uff01");
            }
        }
    }

    public String selectUserRoleGroup(Long userId) {
        List list = this.roleMapper.selectRolesByUserId(userId);
        StringBuffer idsStr = new StringBuffer();
        for (Role role : list) {
            idsStr.append(role.getRoleName()).append(",");
        }
        if (StringUtils.isNotEmpty((String)idsStr.toString())) {
            return idsStr.substring(0, idsStr.length() - 1);
        }
        return idsStr.toString();
    }

    public String selectUserPostGroup(Long userId) {
        List list = this.postMapper.selectPostsByUserId(userId);
        StringBuffer idsStr = new StringBuffer();
        for (Post post : list) {
            idsStr.append(post.getPostName()).append(",");
        }
        if (StringUtils.isNotEmpty((String)idsStr.toString())) {
            return idsStr.substring(0, idsStr.length() - 1);
        }
        return idsStr.toString();
    }

    public String importUser(List<User> userList, Boolean isUpdateSupport) {
        if (StringUtils.isNull(userList) || userList.size() == 0) {
            throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        String operName = ShiroUtils.getLoginName();
        String password = this.configService.selectConfigByKey("sys.user.initPassword");
        for (User user : userList) {
            try {
                User u = this.userMapper.selectUserByLoginName(user.getLoginName());
                if (StringUtils.isNull((Object)u)) {
                    user.setPassword(password);
                    user.setCreateBy(operName);
                    this.insertUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5bfc\u5165\u6210\u529f");
                    continue;
                }
                if (isUpdateSupport.booleanValue()) {
                    user.setUpdateBy(operName);
                    this.updateUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5df2\u5b58\u5728");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new ServiceException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }

    public int changeStatus(User user) {
        return this.userMapper.updateUser(user);
    }
}

