/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.user.controller;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.config.RuoYiConfig;
import com.ruoyi.framework.shiro.service.PasswordService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.project.system.user.domain.User;
import com.ruoyi.project.system.user.service.IUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/system/user/profile"})
public class ProfileController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ProfileController.class);
    private String prefix = "system/user/profile";
    @Autowired
    private IUserService userService;
    @Autowired
    private PasswordService passwordService;

    @GetMapping
    public String profile(ModelMap mmap) {
        User user = this.getSysUser();
        mmap.put((Object)"user", (Object)user);
        mmap.put((Object)"roleGroup", (Object)this.userService.selectUserRoleGroup(user.getUserId()));
        mmap.put((Object)"postGroup", (Object)this.userService.selectUserPostGroup(user.getUserId()));
        return this.prefix + "/profile";
    }

    @GetMapping(value={"/checkPassword"})
    @ResponseBody
    public boolean checkPassword(String password) {
        User user = this.getSysUser();
        return this.passwordService.matches(user, password);
    }

    @GetMapping(value={"/resetPwd"})
    public String resetPwd(ModelMap mmap) {
        User user = this.getSysUser();
        mmap.put((Object)"user", (Object)this.userService.selectUserById(user.getUserId()));
        return this.prefix + "/resetPwd";
    }

    @Log(title="\u91cd\u7f6e\u5bc6\u7801", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/resetPwd"})
    @ResponseBody
    public AjaxResult resetPwd(String oldPassword, String newPassword) {
        User user = this.getSysUser();
        if (!this.passwordService.matches(user, oldPassword)) {
            return this.error("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        if (this.passwordService.matches(user, newPassword)) {
            return this.error("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        user.setPassword(newPassword);
        user.setPwdUpdateDate(DateUtils.getNowDate());
        if (this.userService.resetUserPwd(user) > 0) {
            this.setSysUser(this.userService.selectUserById(user.getUserId()));
            return this.success();
        }
        return this.error("\u4fee\u6539\u5bc6\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @GetMapping(value={"/edit"})
    public String edit(ModelMap mmap) {
        User user = this.getSysUser();
        mmap.put((Object)"user", (Object)this.userService.selectUserById(user.getUserId()));
        return this.prefix + "/edit";
    }

    @GetMapping(value={"/avatar"})
    public String avatar(ModelMap mmap) {
        User user = this.getSysUser();
        mmap.put((Object)"user", (Object)this.userService.selectUserById(user.getUserId()));
        return this.prefix + "/avatar";
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    public AjaxResult update(User user) {
        User currentUser = this.getSysUser();
        currentUser.setUserName(user.getUserName());
        currentUser.setEmail(user.getEmail());
        currentUser.setPhonenumber(user.getPhonenumber());
        currentUser.setSex(user.getSex());
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(currentUser))) {
            return this.error("\u4fee\u6539\u7528\u6237'" + currentUser.getLoginName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(currentUser))) {
            return this.error("\u4fee\u6539\u7528\u6237'" + currentUser.getLoginName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (this.userService.updateUserInfo(currentUser) > 0) {
            this.setSysUser(this.userService.selectUserById(currentUser.getUserId()));
            return this.success();
        }
        return this.error();
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/updateAvatar"})
    @ResponseBody
    public AjaxResult updateAvatar(@RequestParam(value="avatarfile") MultipartFile file) {
        User currentUser = this.getSysUser();
        try {
            if (!file.isEmpty()) {
                String avatar = FileUploadUtils.upload((String)RuoYiConfig.getAvatarPath(), (MultipartFile)file);
                currentUser.setAvatar(avatar);
                if (this.userService.updateUserInfo(currentUser) > 0) {
                    this.setSysUser(this.userService.selectUserById(currentUser.getUserId()));
                    return this.success();
                }
            }
            return this.error();
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5934\u50cf\u5931\u8d25\uff01", (Throwable)e);
            return this.error(e.getMessage());
        }
    }
}

