/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.user.controller;

import com.ruoyi.common.utils.CookieUtils;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.config.RuoYiConfig;
import com.ruoyi.framework.shiro.service.PasswordService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.project.system.config.service.IConfigService;
import com.ruoyi.project.system.menu.service.IMenuService;
import com.ruoyi.project.system.user.domain.User;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexController
extends BaseController {
    @Autowired
    private IMenuService menuService;
    @Autowired
    private IConfigService configService;
    @Autowired
    private PasswordService passwordService;
    @Autowired
    private RuoYiConfig ruoYiConfig;

    @GetMapping(value={"/index"})
    public String index(ModelMap mmap) {
        Cookie[] cookies;
        User user = this.getSysUser();
        List menus = this.menuService.selectMenusByUser(user);
        mmap.put((Object)"menus", (Object)menus);
        mmap.put((Object)"user", (Object)user);
        mmap.put((Object)"sideTheme", (Object)this.configService.selectConfigByKey("sys.index.sideTheme"));
        mmap.put((Object)"skinName", (Object)this.configService.selectConfigByKey("sys.index.skinName"));
        mmap.put((Object)"ignoreFooter", (Object)this.configService.selectConfigByKey("sys.index.ignoreFooter"));
        mmap.put((Object)"copyrightYear", (Object)this.ruoYiConfig.getCopyrightYear());
        mmap.put((Object)"demoEnabled", (Object)this.ruoYiConfig.isDemoEnabled());
        mmap.put((Object)"isDefaultModifyPwd", (Object)this.initPasswordIsModify(user.getPwdUpdateDate()));
        mmap.put((Object)"isPasswordExpired", (Object)this.passwordIsExpiration(user.getPwdUpdateDate()));
        mmap.put((Object)"isMobile", (Object)ServletUtils.checkAgentIsMobile((String)ServletUtils.getRequest().getHeader("User-Agent")));
        String menuStyle = this.configService.selectConfigByKey("sys.index.menuStyle");
        String indexStyle = ServletUtils.checkAgentIsMobile((String)ServletUtils.getRequest().getHeader("User-Agent")) ? "index" : menuStyle;
        for (Cookie cookie : cookies = ServletUtils.getRequest().getCookies()) {
            if (!StringUtils.isNotEmpty((String)cookie.getName()) || !"nav-style".equalsIgnoreCase(cookie.getName())) continue;
            indexStyle = cookie.getValue();
            break;
        }
        String webIndex = "topnav".equalsIgnoreCase(indexStyle) ? "index-topnav" : "index";
        return webIndex;
    }

    @GetMapping(value={"/lockscreen"})
    public String lockscreen(ModelMap mmap) {
        mmap.put((Object)"user", (Object)this.getSysUser());
        ServletUtils.getSession().setAttribute("lockscreen", (Object)true);
        return "lock";
    }

    @PostMapping(value={"/unlockscreen"})
    @ResponseBody
    public AjaxResult unlockscreen(String password) {
        User user = this.getSysUser();
        if (StringUtils.isNull((Object)user)) {
            return AjaxResult.error((String)"\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        if (this.passwordService.matches(user, password)) {
            ServletUtils.getSession().removeAttribute("lockscreen");
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
    }

    @GetMapping(value={"/system/switchSkin"})
    public String switchSkin() {
        return "skin";
    }

    @GetMapping(value={"/system/menuStyle/{style}"})
    public void menuStyle(@PathVariable String style, HttpServletResponse response) {
        CookieUtils.setCookie((HttpServletResponse)response, (String)"nav-style", (String)style);
    }

    @GetMapping(value={"/system/main"})
    public String main(ModelMap mmap) {
        mmap.put((Object)"version", (Object)this.ruoYiConfig.getVersion());
        return "main";
    }

    public boolean initPasswordIsModify(Date pwdUpdateDate) {
        Integer initPasswordModify = Convert.toInt((Object)this.configService.selectConfigByKey("sys.account.initPasswordModify"));
        return initPasswordModify != null && initPasswordModify == 1 && pwdUpdateDate == null;
    }

    public boolean passwordIsExpiration(Date pwdUpdateDate) {
        Integer passwordValidateDays = Convert.toInt((Object)this.configService.selectConfigByKey("sys.account.passwordValidateDays"));
        if (passwordValidateDays != null && passwordValidateDays > 0) {
            if (StringUtils.isNull((Object)pwdUpdateDate)) {
                return true;
            }
            Date nowDate = DateUtils.getNowDate();
            return DateUtils.differentDaysByMillisecond((Date)nowDate, (Date)pwdUpdateDate) > passwordValidateDays;
        }
        return false;
    }
}

