/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.role.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.aspectj.lang.annotation.DataScope;
import com.ruoyi.project.system.role.domain.Role;
import com.ruoyi.project.system.role.domain.RoleDept;
import com.ruoyi.project.system.role.domain.RoleMenu;
import com.ruoyi.project.system.role.mapper.RoleDeptMapper;
import com.ruoyi.project.system.role.mapper.RoleMapper;
import com.ruoyi.project.system.role.mapper.RoleMenuMapper;
import com.ruoyi.project.system.role.service.IRoleService;
import com.ruoyi.project.system.user.domain.User;
import com.ruoyi.project.system.user.domain.UserRole;
import com.ruoyi.project.system.user.mapper.UserRoleMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements IRoleService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleDeptMapper roleDeptMapper;

    @DataScope(deptAlias="d")
    public List<Role> selectRoleList(Role role) {
        return this.roleMapper.selectRoleList(role);
    }

    public Set<String> selectRoleKeys(Long userId) {
        List perms = this.roleMapper.selectRolesByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (Role perm : perms) {
            if (!StringUtils.isNotNull((Object)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.getRoleKey().trim().split(",")));
        }
        return permsSet;
    }

    public List<Role> selectRolesByUserId(Long userId) {
        List userRoles = this.roleMapper.selectRolesByUserId(userId);
        List roles = this.selectRoleAll();
        block0: for (Role role : roles) {
            for (Role userRole : userRoles) {
                if (role.getRoleId().longValue() != userRole.getRoleId().longValue()) continue;
                role.setFlag(true);
                continue block0;
            }
        }
        return roles;
    }

    public List<Role> selectRoleAll() {
        return ((RoleServiceImpl)SpringUtils.getAopProxy((Object)this)).selectRoleList(new Role());
    }

    public Role selectRoleById(Long roleId) {
        return this.roleMapper.selectRoleById(roleId);
    }

    @Transactional
    public boolean deleteRoleById(Long roleId) {
        this.roleMenuMapper.deleteRoleMenuByRoleId(roleId);
        this.roleDeptMapper.deleteRoleDeptByRoleId(roleId);
        return this.roleMapper.deleteRoleById(roleId) > 0;
    }

    @Transactional
    public int deleteRoleByIds(String ids) {
        Long[] roleIds;
        for (Long roleId : roleIds = Convert.toLongArray((String)ids)) {
            this.checkRoleAllowed(new Role(roleId));
            Role role = this.selectRoleById(roleId);
            if (this.countUserRoleByRoleId(roleId) <= 0) continue;
            throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", role.getRoleName()));
        }
        this.roleMenuMapper.deleteRoleMenu(roleIds);
        this.roleDeptMapper.deleteRoleDept(roleIds);
        return this.roleMapper.deleteRoleByIds(roleIds);
    }

    @Transactional
    public int insertRole(Role role) {
        role.setCreateBy(ShiroUtils.getLoginName());
        this.roleMapper.insertRole(role);
        return this.insertRoleMenu(role);
    }

    @Transactional
    public int updateRole(Role role) {
        role.setUpdateBy(ShiroUtils.getLoginName());
        this.roleMapper.updateRole(role);
        this.roleMenuMapper.deleteRoleMenuByRoleId(role.getRoleId());
        return this.insertRoleMenu(role);
    }

    @Transactional
    public int authDataScope(Role role) {
        role.setUpdateBy(ShiroUtils.getLoginName());
        this.roleMapper.updateRole(role);
        this.roleDeptMapper.deleteRoleDeptByRoleId(role.getRoleId());
        return this.insertRoleDept(role);
    }

    public int insertRoleMenu(Role role) {
        int rows = 1;
        ArrayList<RoleMenu> list = new ArrayList<RoleMenu>();
        for (Long menuId : role.getMenuIds()) {
            RoleMenu rm = new RoleMenu();
            rm.setRoleId(role.getRoleId());
            rm.setMenuId(menuId);
            list.add(rm);
        }
        if (list.size() > 0) {
            rows = this.roleMenuMapper.batchRoleMenu(list);
        }
        return rows;
    }

    public int insertRoleDept(Role role) {
        int rows = 1;
        ArrayList<RoleDept> list = new ArrayList<RoleDept>();
        for (Long deptId : role.getDeptIds()) {
            RoleDept rd = new RoleDept();
            rd.setRoleId(role.getRoleId());
            rd.setDeptId(deptId);
            list.add(rd);
        }
        if (list.size() > 0) {
            rows = this.roleDeptMapper.batchRoleDept(list);
        }
        return rows;
    }

    public String checkRoleNameUnique(Role role) {
        Long roleId = StringUtils.isNull((Object)role.getRoleId()) ? -1L : role.getRoleId();
        Role info = this.roleMapper.checkRoleNameUnique(role.getRoleName());
        if (StringUtils.isNotNull((Object)info) && info.getRoleId().longValue() != roleId.longValue()) {
            return "1";
        }
        return "0";
    }

    public String checkRoleKeyUnique(Role role) {
        Long roleId = StringUtils.isNull((Object)role.getRoleId()) ? -1L : role.getRoleId();
        Role info = this.roleMapper.checkRoleKeyUnique(role.getRoleKey());
        if (StringUtils.isNotNull((Object)info) && info.getRoleId().longValue() != roleId.longValue()) {
            return "1";
        }
        return "0";
    }

    public void checkRoleAllowed(Role role) {
        if (StringUtils.isNotNull((Object)role.getRoleId()) && role.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272");
        }
    }

    public void checkRoleDataScope(Long roleId) {
        if (!User.isAdmin((Long)ShiroUtils.getUserId())) {
            Role role = new Role();
            role.setRoleId(roleId);
            List roles = ((RoleServiceImpl)SpringUtils.getAopProxy((Object)this)).selectRoleList(role);
            if (StringUtils.isEmpty((Collection)roles)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u89d2\u8272\u6570\u636e\uff01");
            }
        }
    }

    public int countUserRoleByRoleId(Long roleId) {
        return this.userRoleMapper.countUserRoleByRoleId(roleId);
    }

    public int changeStatus(Role role) {
        return this.roleMapper.updateRole(role);
    }

    public int deleteAuthUser(UserRole userRole) {
        return this.userRoleMapper.deleteUserRoleInfo(userRole);
    }

    public int deleteAuthUsers(Long roleId, String userIds) {
        return this.userRoleMapper.deleteUserRoleInfos(roleId, Convert.toLongArray((String)userIds));
    }

    public int insertAuthUsers(Long roleId, String userIds) {
        Long[] users = Convert.toLongArray((String)userIds);
        ArrayList<UserRole> list = new ArrayList<UserRole>();
        for (Long userId : users) {
            UserRole ur = new UserRole();
            ur.setUserId(userId);
            ur.setRoleId(roleId);
            list.add(ur);
        }
        return this.userRoleMapper.batchUserRole(list);
    }
}

