/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.post.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.project.system.post.domain.Post;
import com.ruoyi.project.system.post.mapper.PostMapper;
import com.ruoyi.project.system.post.service.IPostService;
import com.ruoyi.project.system.user.mapper.UserPostMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostServiceImpl
implements IPostService {
    @Autowired
    private PostMapper postMapper;
    @Autowired
    private UserPostMapper userPostMapper;

    public List<Post> selectPostList(Post post) {
        return this.postMapper.selectPostList(post);
    }

    public List<Post> selectPostAll() {
        return this.postMapper.selectPostAll();
    }

    public List<Post> selectPostsByUserId(Long userId) {
        List userPosts = this.postMapper.selectPostsByUserId(userId);
        List posts = this.postMapper.selectPostAll();
        block0: for (Post post : posts) {
            for (Post userRole : userPosts) {
                if (post.getPostId().longValue() != userRole.getPostId().longValue()) continue;
                post.setFlag(true);
                continue block0;
            }
        }
        return posts;
    }

    public Post selectPostById(Long postId) {
        return this.postMapper.selectPostById(postId);
    }

    public int deletePostByIds(String ids) {
        Long[] postIds;
        for (Long postId : postIds = Convert.toLongArray((String)ids)) {
            Post post = this.selectPostById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.postMapper.deletePostByIds(postIds);
    }

    public int insertPost(Post post) {
        post.setCreateBy(ShiroUtils.getLoginName());
        return this.postMapper.insertPost(post);
    }

    public int updatePost(Post post) {
        post.setUpdateBy(ShiroUtils.getLoginName());
        return this.postMapper.updatePost(post);
    }

    public int countUserPostById(Long postId) {
        return this.userPostMapper.countUserPostById(postId);
    }

    public String checkPostNameUnique(Post post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        Post info = this.postMapper.checkPostNameUnique(post.getPostName());
        if (StringUtils.isNotNull((Object)info) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }

    public String checkPostCodeUnique(Post post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        Post info = this.postMapper.checkPostCodeUnique(post.getPostCode());
        if (StringUtils.isNotNull((Object)info) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }
}

