/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.notice.controller;

import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.system.notice.domain.Notice;
import com.ruoyi.project.system.notice.service.INoticeService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/notice"})
public class NoticeController
extends BaseController {
    private String prefix = "system/notice";
    @Autowired
    private INoticeService noticeService;

    @RequiresPermissions(value={"system:notice:view"})
    @GetMapping
    public String notice() {
        return this.prefix + "/notice";
    }

    @RequiresPermissions(value={"system:notice:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(Notice notice) {
        this.startPage();
        List list = this.noticeService.selectNoticeList(notice);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:notice:add"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(Notice notice) {
        return this.toAjax(this.noticeService.insertNotice(notice));
    }

    @GetMapping(value={"/edit/{noticeId}"})
    public String edit(@PathVariable(value="noticeId") Long noticeId, ModelMap mmap) {
        mmap.put((Object)"notice", (Object)this.noticeService.selectNoticeById(noticeId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:notice:edit"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(Notice notice) {
        return this.toAjax(this.noticeService.updateNotice(notice));
    }

    @RequiresPermissions(value={"system:notice:remove"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.noticeService.deleteNoticeByIds(ids));
    }
}

