/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.menu.service;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.TreeUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.web.domain.Ztree;
import com.ruoyi.project.system.menu.domain.Menu;
import com.ruoyi.project.system.menu.mapper.MenuMapper;
import com.ruoyi.project.system.menu.service.IMenuService;
import com.ruoyi.project.system.role.domain.Role;
import com.ruoyi.project.system.role.mapper.RoleMenuMapper;
import com.ruoyi.project.system.user.domain.User;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
implements IMenuService {
    public static final String PREMISSION_STRING = "perms[\"{0}\"]";
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;

    public List<Menu> selectMenusByUser(User user) {
        List menus = new LinkedList();
        menus = user.isAdmin() ? this.menuMapper.selectMenuNormalAll() : this.menuMapper.selectMenusByUserId(user.getUserId());
        return TreeUtils.getChildPerms(menus, (int)0);
    }

    public List<Menu> selectMenuList(Menu menu) {
        List menuList = null;
        User user = ShiroUtils.getSysUser();
        if (user.isAdmin()) {
            menuList = this.menuMapper.selectMenuList(menu);
        } else {
            menu.getParams().put("userId", user.getUserId());
            menuList = this.menuMapper.selectMenuListByUserId(menu);
        }
        return menuList;
    }

    public List<Menu> selectMenuAll() {
        List menuList = null;
        User user = ShiroUtils.getSysUser();
        menuList = user.isAdmin() ? this.menuMapper.selectMenuAll() : this.menuMapper.selectMenuAllByUserId(user.getUserId());
        return menuList;
    }

    public Set<String> selectPermsByUserId(Long userId) {
        List perms = this.menuMapper.selectPermsByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty((String)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    public List<Ztree> roleMenuTreeData(Role role) {
        Long roleId = role.getRoleId();
        List ztrees = new ArrayList();
        List menuList = this.selectMenuAll();
        if (StringUtils.isNotNull((Object)roleId)) {
            List roleMenuList = this.menuMapper.selectMenuTree(roleId);
            ztrees = this.initZtree(menuList, roleMenuList, true);
        } else {
            ztrees = this.initZtree(menuList, null, true);
        }
        return ztrees;
    }

    public List<Ztree> menuTreeData() {
        List menuList = this.selectMenuAll();
        List ztrees = this.initZtree(menuList);
        return ztrees;
    }

    public LinkedHashMap<String, String> selectPermsAll() {
        LinkedHashMap<String, String> section = new LinkedHashMap<String, String>();
        List permissions = this.selectMenuAll();
        if (StringUtils.isNotEmpty((Collection)permissions)) {
            for (Menu menu : permissions) {
                section.put(menu.getUrl(), MessageFormat.format(PREMISSION_STRING, menu.getPerms()));
            }
        }
        return section;
    }

    public List<Ztree> initZtree(List<Menu> menuList) {
        return this.initZtree(menuList, null, false);
    }

    public List<Ztree> initZtree(List<Menu> menuList, List<String> roleMenuList, boolean permsFlag) {
        ArrayList<Ztree> ztrees = new ArrayList<Ztree>();
        boolean isCheck = StringUtils.isNotNull(roleMenuList);
        for (Menu menu : menuList) {
            Ztree ztree = new Ztree();
            ztree.setId(menu.getMenuId());
            ztree.setpId(menu.getParentId());
            ztree.setName(this.transMenuName(menu, permsFlag));
            ztree.setTitle(menu.getMenuName());
            if (isCheck) {
                ztree.setChecked(roleMenuList.contains(menu.getMenuId() + menu.getPerms()));
            }
            ztrees.add(ztree);
        }
        return ztrees;
    }

    public String transMenuName(Menu menu, boolean permsFlag) {
        StringBuffer sb = new StringBuffer();
        sb.append(menu.getMenuName());
        if (permsFlag) {
            sb.append("<font color=\"#888\">&nbsp;&nbsp;&nbsp;" + menu.getPerms() + "</font>");
        }
        return sb.toString();
    }

    public int deleteMenuById(Long menuId) {
        return this.menuMapper.deleteMenuById(menuId);
    }

    public Menu selectMenuById(Long menuId) {
        return this.menuMapper.selectMenuById(menuId);
    }

    public int selectCountMenuByParentId(Long parentId) {
        return this.menuMapper.selectCountMenuByParentId(parentId);
    }

    public int selectCountRoleMenuByMenuId(Long menuId) {
        return this.roleMenuMapper.selectCountRoleMenuByMenuId(menuId);
    }

    public int insertMenu(Menu menu) {
        menu.setCreateBy(ShiroUtils.getLoginName());
        return this.menuMapper.insertMenu(menu);
    }

    public int updateMenu(Menu menu) {
        menu.setUpdateBy(ShiroUtils.getLoginName());
        return this.menuMapper.updateMenu(menu);
    }

    public String checkMenuNameUnique(Menu menu) {
        Long menuId = StringUtils.isNull((Object)menu.getMenuId()) ? -1L : menu.getMenuId();
        Menu info = this.menuMapper.checkMenuNameUnique(menu.getMenuName(), menu.getParentId());
        if (StringUtils.isNotNull((Object)info) && info.getMenuId().longValue() != menuId.longValue()) {
            return "1";
        }
        return "0";
    }
}

