/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.menu.controller;

import com.ruoyi.common.utils.security.AuthorizationUtils;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.domain.Ztree;
import com.ruoyi.project.system.menu.domain.Menu;
import com.ruoyi.project.system.menu.service.IMenuService;
import com.ruoyi.project.system.role.domain.Role;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/menu"})
public class MenuController
extends BaseController {
    private String prefix = "system/menu";
    @Autowired
    private IMenuService menuService;

    @RequiresPermissions(value={"system:menu:view"})
    @GetMapping
    public String menu() {
        return this.prefix + "/menu";
    }

    @RequiresPermissions(value={"system:menu:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public List<Menu> list(Menu menu) {
        List menuList = this.menuService.selectMenuList(menu);
        return menuList;
    }

    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"system:menu:remove"})
    @GetMapping(value={"/remove/{menuId}"})
    @ResponseBody
    public AjaxResult remove(@PathVariable(value="menuId") Long menuId) {
        if (this.menuService.selectCountMenuByParentId(menuId) > 0) {
            return AjaxResult.warn((String)"\u5b58\u5728\u5b50\u83dc\u5355,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.menuService.selectCountRoleMenuByMenuId(menuId) > 0) {
            return AjaxResult.warn((String)"\u83dc\u5355\u5df2\u5206\u914d,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        AuthorizationUtils.clearAllCachedAuthorizationInfo();
        return this.toAjax(this.menuService.deleteMenuById(menuId));
    }

    @GetMapping(value={"/add/{parentId}"})
    public String add(@PathVariable(value="parentId") Long parentId, ModelMap mmap) {
        Menu menu = null;
        if (0L != parentId) {
            menu = this.menuService.selectMenuById(parentId);
        } else {
            menu = new Menu();
            menu.setMenuId(Long.valueOf(0L));
            menu.setMenuName("\u4e3b\u76ee\u5f55");
        }
        mmap.put((Object)"menu", (Object)menu);
        return this.prefix + "/add";
    }

    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"system:menu:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated Menu menu) {
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return this.error("\u65b0\u589e\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        AuthorizationUtils.clearAllCachedAuthorizationInfo();
        return this.toAjax(this.menuService.insertMenu(menu));
    }

    @GetMapping(value={"/edit/{menuId}"})
    public String edit(@PathVariable(value="menuId") Long menuId, ModelMap mmap) {
        mmap.put((Object)"menu", (Object)this.menuService.selectMenuById(menuId));
        return this.prefix + "/edit";
    }

    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:menu:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated Menu menu) {
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return this.error("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        AuthorizationUtils.clearAllCachedAuthorizationInfo();
        return this.toAjax(this.menuService.updateMenu(menu));
    }

    @GetMapping(value={"/icon"})
    public String icon() {
        return this.prefix + "/icon";
    }

    @PostMapping(value={"/checkMenuNameUnique"})
    @ResponseBody
    public String checkMenuNameUnique(Menu menu) {
        return this.menuService.checkMenuNameUnique(menu);
    }

    @GetMapping(value={"/roleMenuTreeData"})
    @ResponseBody
    public List<Ztree> roleMenuTreeData(Role role) {
        List ztrees = this.menuService.roleMenuTreeData(role);
        return ztrees;
    }

    @GetMapping(value={"/menuTreeData"})
    @ResponseBody
    public List<Ztree> menuTreeData(Role role) {
        List ztrees = this.menuService.menuTreeData();
        return ztrees;
    }

    @GetMapping(value={"/selectMenuTree/{menuId}"})
    public String selectMenuTree(@PathVariable(value="menuId") Long menuId, ModelMap mmap) {
        mmap.put((Object)"menu", (Object)this.menuService.selectMenuById(menuId));
        return this.prefix + "/tree";
    }
}

