/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.dict.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.web.domain.Ztree;
import com.ruoyi.project.system.dict.domain.DictData;
import com.ruoyi.project.system.dict.domain.DictType;
import com.ruoyi.project.system.dict.mapper.DictDataMapper;
import com.ruoyi.project.system.dict.mapper.DictTypeMapper;
import com.ruoyi.project.system.dict.service.IDictTypeService;
import com.ruoyi.project.system.dict.utils.DictUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTypeServiceImpl
implements IDictTypeService {
    @Autowired
    private DictTypeMapper dictTypeMapper;
    @Autowired
    private DictDataMapper dictDataMapper;

    @PostConstruct
    public void init() {
        this.loadingDictCache();
    }

    public List<DictType> selectDictTypeList(DictType dictType) {
        return this.dictTypeMapper.selectDictTypeList(dictType);
    }

    public List<DictType> selectDictTypeAll() {
        return this.dictTypeMapper.selectDictTypeAll();
    }

    public List<DictData> selectDictDataByType(String dictType) {
        List dictDatas = DictUtils.getDictCache((String)dictType);
        if (StringUtils.isNotEmpty((Collection)dictDatas)) {
            return dictDatas;
        }
        dictDatas = this.dictDataMapper.selectDictDataByType(dictType);
        if (StringUtils.isNotEmpty((Collection)dictDatas)) {
            DictUtils.setDictCache((String)dictType, (List)dictDatas);
            return dictDatas;
        }
        return null;
    }

    public DictType selectDictTypeById(Long dictId) {
        return this.dictTypeMapper.selectDictTypeById(dictId);
    }

    public DictType selectDictTypeByType(String dictType) {
        return this.dictTypeMapper.selectDictTypeByType(dictType);
    }

    public void deleteDictTypeByIds(String ids) {
        Long[] dictIds;
        for (Long dictId : dictIds = Convert.toLongArray((String)ids)) {
            DictType dictType = this.selectDictTypeById(dictId);
            if (this.dictDataMapper.countDictDataByType(dictType.getDictType()) > 0) {
                throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", dictType.getDictName()));
            }
            this.dictTypeMapper.deleteDictTypeById(dictId);
            DictUtils.removeDictCache((String)dictType.getDictType());
        }
    }

    public void loadingDictCache() {
        List dictTypeList = this.dictTypeMapper.selectDictTypeAll();
        for (DictType dict : dictTypeList) {
            List dictDatas = this.dictDataMapper.selectDictDataByType(dict.getDictType());
            DictUtils.setDictCache((String)dict.getDictType(), (List)dictDatas);
        }
    }

    public void clearDictCache() {
        DictUtils.clearDictCache();
    }

    public void resetDictCache() {
        this.clearDictCache();
        this.loadingDictCache();
    }

    public int insertDictType(DictType dict) {
        dict.setCreateBy(ShiroUtils.getLoginName());
        int row = this.dictTypeMapper.insertDictType(dict);
        if (row > 0) {
            DictUtils.setDictCache((String)dict.getDictType(), null);
        }
        return row;
    }

    @Transactional
    public int updateDictType(DictType dict) {
        dict.setUpdateBy(ShiroUtils.getLoginName());
        DictType oldDict = this.dictTypeMapper.selectDictTypeById(dict.getDictId());
        this.dictDataMapper.updateDictDataType(oldDict.getDictType(), dict.getDictType());
        int row = this.dictTypeMapper.updateDictType(dict);
        if (row > 0) {
            List dictDatas = this.dictDataMapper.selectDictDataByType(dict.getDictType());
            DictUtils.setDictCache((String)dict.getDictType(), (List)dictDatas);
        }
        return row;
    }

    public String checkDictTypeUnique(DictType dict) {
        Long dictId = StringUtils.isNull((Object)dict.getDictId()) ? -1L : dict.getDictId();
        DictType dictType = this.dictTypeMapper.checkDictTypeUnique(dict.getDictType());
        if (StringUtils.isNotNull((Object)dictType) && dictType.getDictId().longValue() != dictId.longValue()) {
            return "1";
        }
        return "0";
    }

    public List<Ztree> selectDictTree(DictType dictType) {
        ArrayList<Ztree> ztrees = new ArrayList<Ztree>();
        List dictList = this.dictTypeMapper.selectDictTypeList(dictType);
        for (DictType dict : dictList) {
            if (!"0".equals(dict.getStatus())) continue;
            Ztree ztree = new Ztree();
            ztree.setId(dict.getDictId());
            ztree.setName(this.transDictName(dict));
            ztree.setTitle(dict.getDictType());
            ztrees.add(ztree);
        }
        return ztrees;
    }

    public String transDictName(DictType dictType) {
        StringBuffer sb = new StringBuffer();
        sb.append("(" + dictType.getDictName() + ")");
        sb.append("&nbsp;&nbsp;&nbsp;" + dictType.getDictType());
        return sb.toString();
    }
}

