/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.dict.service;

import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.project.system.dict.domain.DictData;
import com.ruoyi.project.system.dict.mapper.DictDataMapper;
import com.ruoyi.project.system.dict.service.IDictDataService;
import com.ruoyi.project.system.dict.utils.DictUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictDataServiceImpl
implements IDictDataService {
    @Autowired
    private DictDataMapper dictDataMapper;

    public List<DictData> selectDictDataList(DictData dictData) {
        return this.dictDataMapper.selectDictDataList(dictData);
    }

    public String selectDictLabel(String dictType, String dictValue) {
        return this.dictDataMapper.selectDictLabel(dictType, dictValue);
    }

    public DictData selectDictDataById(Long dictCode) {
        return this.dictDataMapper.selectDictDataById(dictCode);
    }

    public void deleteDictDataByIds(String ids) {
        Long[] dictCodes;
        for (Long dictCode : dictCodes = Convert.toLongArray((String)ids)) {
            DictData data = this.selectDictDataById(dictCode);
            this.dictDataMapper.deleteDictDataById(dictCode);
            List dictDatas = this.dictDataMapper.selectDictDataByType(data.getDictType());
            DictUtils.setDictCache((String)data.getDictType(), (List)dictDatas);
        }
    }

    public int insertDictData(DictData data) {
        data.setCreateBy(ShiroUtils.getLoginName());
        int row = this.dictDataMapper.insertDictData(data);
        if (row > 0) {
            List dictDatas = this.dictDataMapper.selectDictDataByType(data.getDictType());
            DictUtils.setDictCache((String)data.getDictType(), (List)dictDatas);
        }
        return row;
    }

    public int updateDictData(DictData data) {
        data.setUpdateBy(ShiroUtils.getLoginName());
        int row = this.dictDataMapper.updateDictData(data);
        if (row > 0) {
            List dictDatas = this.dictDataMapper.selectDictDataByType(data.getDictType());
            DictUtils.setDictCache((String)data.getDictType(), (List)dictDatas);
        }
        return row;
    }
}

