/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.dept.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.aspectj.lang.annotation.DataScope;
import com.ruoyi.framework.web.domain.Ztree;
import com.ruoyi.project.system.dept.domain.Dept;
import com.ruoyi.project.system.dept.mapper.DeptMapper;
import com.ruoyi.project.system.dept.service.IDeptService;
import com.ruoyi.project.system.role.domain.Role;
import com.ruoyi.project.system.user.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeptServiceImpl
implements IDeptService {
    @Autowired
    private DeptMapper deptMapper;

    @DataScope(deptAlias="d")
    public List<Dept> selectDeptList(Dept dept) {
        return this.deptMapper.selectDeptList(dept);
    }

    @DataScope(deptAlias="d")
    public List<Ztree> selectDeptTree(Dept dept) {
        List deptList = this.deptMapper.selectDeptList(dept);
        List ztrees = this.initZtree(deptList);
        return ztrees;
    }

    @DataScope(deptAlias="d")
    public List<Ztree> selectDeptTreeExcludeChild(Dept dept) {
        Long excludeId = dept.getExcludeId();
        List deptList = this.deptMapper.selectDeptList(dept);
        Iterator it = deptList.iterator();
        while (it.hasNext()) {
            Dept d = (Dept)it.next();
            if ((long)d.getDeptId().intValue() != excludeId && !ArrayUtils.contains((Object[])StringUtils.split((String)d.getAncestors(), (String)","), (Object)(excludeId + ""))) continue;
            it.remove();
        }
        List ztrees = this.initZtree(deptList);
        return ztrees;
    }

    public List<Ztree> roleDeptTreeData(Role role) {
        Long roleId = role.getRoleId();
        List ztrees = new ArrayList();
        List deptList = this.selectDeptList(new Dept());
        if (StringUtils.isNotNull((Object)roleId)) {
            List roleDeptList = this.deptMapper.selectRoleDeptTree(roleId);
            ztrees = this.initZtree(deptList, roleDeptList);
        } else {
            ztrees = this.initZtree(deptList);
        }
        return ztrees;
    }

    public List<Ztree> initZtree(List<Dept> deptList) {
        return this.initZtree(deptList, null);
    }

    public List<Ztree> initZtree(List<Dept> deptList, List<String> roleDeptList) {
        ArrayList<Ztree> ztrees = new ArrayList<Ztree>();
        boolean isCheck = StringUtils.isNotNull(roleDeptList);
        for (Dept dept : deptList) {
            if (!"0".equals(dept.getStatus())) continue;
            Ztree ztree = new Ztree();
            ztree.setId(dept.getDeptId());
            ztree.setpId(dept.getParentId());
            ztree.setName(dept.getDeptName());
            ztree.setTitle(dept.getDeptName());
            if (isCheck) {
                ztree.setChecked(roleDeptList.contains(dept.getDeptId() + dept.getDeptName()));
            }
            ztrees.add(ztree);
        }
        return ztrees;
    }

    public int selectDeptCount(Long parentId) {
        Dept dept = new Dept();
        dept.setParentId(parentId);
        return this.deptMapper.selectDeptCount(dept);
    }

    public boolean checkDeptExistUser(Long deptId) {
        int result = this.deptMapper.checkDeptExistUser(deptId);
        return result > 0;
    }

    public int deleteDeptById(Long deptId) {
        return this.deptMapper.deleteDeptById(deptId);
    }

    public int insertDept(Dept dept) {
        Dept info = this.deptMapper.selectDeptById(dept.getParentId());
        if (!"0".equals(info.getStatus())) {
            throw new ServiceException("\u90e8\u95e8\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        dept.setCreateBy(ShiroUtils.getLoginName());
        dept.setAncestors(info.getAncestors() + "," + dept.getParentId());
        return this.deptMapper.insertDept(dept);
    }

    @Transactional
    public int updateDept(Dept dept) {
        Dept newParentDept = this.deptMapper.selectDeptById(dept.getParentId());
        Dept oldDept = this.selectDeptById(dept.getDeptId());
        if (StringUtils.isNotNull((Object)newParentDept) && StringUtils.isNotNull((Object)oldDept)) {
            String newAncestors = newParentDept.getAncestors() + "," + newParentDept.getDeptId();
            String oldAncestors = oldDept.getAncestors();
            dept.setAncestors(newAncestors);
            this.updateDeptChildren(dept.getDeptId(), newAncestors, oldAncestors);
        }
        dept.setUpdateBy(ShiroUtils.getLoginName());
        int result = this.deptMapper.updateDept(dept);
        if ("0".equals(dept.getStatus()) && StringUtils.isNotEmpty((String)dept.getAncestors()) && !StringUtils.equals((CharSequence)"0", (CharSequence)dept.getAncestors())) {
            this.updateParentDeptStatusNormal(dept);
        }
        return result;
    }

    private void updateParentDeptStatusNormal(Dept dept) {
        String ancestors = dept.getAncestors();
        Long[] deptIds = Convert.toLongArray((String)ancestors);
        this.deptMapper.updateDeptStatusNormal(deptIds);
    }

    public void updateDeptChildren(Long deptId, String newAncestors, String oldAncestors) {
        List children = this.deptMapper.selectChildrenDeptById(deptId);
        for (Dept child : children) {
            child.setAncestors(child.getAncestors().replaceFirst(oldAncestors, newAncestors));
        }
        if (children.size() > 0) {
            this.deptMapper.updateDeptChildren(children);
        }
    }

    public void updateDeptChildren(Long deptId, String ancestors) {
        Dept dept = new Dept();
        dept.setParentId(deptId);
        List childrens = this.deptMapper.selectDeptList(dept);
        for (Dept children : childrens) {
            children.setAncestors(ancestors + "," + dept.getParentId());
        }
        if (childrens.size() > 0) {
            this.deptMapper.updateDeptChildren(childrens);
        }
    }

    public Dept selectDeptById(Long deptId) {
        return this.deptMapper.selectDeptById(deptId);
    }

    public int selectNormalChildrenDeptById(Long deptId) {
        return this.deptMapper.selectNormalChildrenDeptById(deptId);
    }

    public String checkDeptNameUnique(Dept dept) {
        Long deptId = StringUtils.isNull((Object)dept.getDeptId()) ? -1L : dept.getDeptId();
        Dept info = this.deptMapper.checkDeptNameUnique(dept.getDeptName(), dept.getParentId());
        if (StringUtils.isNotNull((Object)info) && info.getDeptId().longValue() != deptId.longValue()) {
            return "1";
        }
        return "0";
    }

    public void checkDeptDataScope(Long deptId) {
        if (!User.isAdmin((Long)ShiroUtils.getUserId())) {
            Dept dept = new Dept();
            dept.setDeptId(deptId);
            List depts = ((DeptServiceImpl)SpringUtils.getAopProxy((Object)this)).selectDeptList(dept);
            if (StringUtils.isEmpty((Collection)depts)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u90e8\u95e8\u6570\u636e\uff01");
            }
        }
    }
}

