/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.dept.controller;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.domain.Ztree;
import com.ruoyi.project.system.dept.domain.Dept;
import com.ruoyi.project.system.dept.service.IDeptService;
import com.ruoyi.project.system.role.domain.Role;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/dept"})
public class DeptController
extends BaseController {
    private String prefix = "system/dept";
    @Autowired
    private IDeptService deptService;

    @RequiresPermissions(value={"system:dept:view"})
    @GetMapping
    public String dept() {
        return this.prefix + "/dept";
    }

    @RequiresPermissions(value={"system:dept:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public List<Dept> list(Dept dept) {
        List deptList = this.deptService.selectDeptList(dept);
        return deptList;
    }

    @GetMapping(value={"/add/{parentId}"})
    public String add(@PathVariable(value="parentId") Long parentId, ModelMap mmap) {
        if (!this.getSysUser().isAdmin()) {
            parentId = this.getSysUser().getDeptId();
        }
        mmap.put((Object)"dept", (Object)this.deptService.selectDeptById(parentId));
        return this.prefix + "/add";
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"system:dept:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated Dept dept) {
        if ("1".equals(this.deptService.checkDeptNameUnique(dept))) {
            return this.error("\u65b0\u589e\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return this.toAjax(this.deptService.insertDept(dept));
    }

    @GetMapping(value={"/edit/{deptId}"})
    public String edit(@PathVariable(value="deptId") Long deptId, ModelMap mmap) {
        this.deptService.checkDeptDataScope(deptId);
        Dept dept = this.deptService.selectDeptById(deptId);
        if (StringUtils.isNotNull((Object)dept) && 100L == deptId) {
            dept.setParentName("\u65e0");
        }
        mmap.put((Object)"dept", (Object)dept);
        return this.prefix + "/edit";
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:dept:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated Dept dept) {
        if ("1".equals(this.deptService.checkDeptNameUnique(dept))) {
            return this.error("\u4fee\u6539\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (dept.getParentId().equals(dept.getDeptId())) {
            return this.error("\u4fee\u6539\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)dept.getStatus()) && this.deptService.selectNormalChildrenDeptById(dept.getDeptId()) > 0) {
            return AjaxResult.error((String)"\u8be5\u90e8\u95e8\u5305\u542b\u672a\u505c\u7528\u7684\u5b50\u90e8\u95e8\uff01");
        }
        return this.toAjax(this.deptService.updateDept(dept));
    }

    @Log(title="\u90e8\u95e8\u7ba1\u7406", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"system:dept:remove"})
    @GetMapping(value={"/remove/{deptId}"})
    @ResponseBody
    public AjaxResult remove(@PathVariable(value="deptId") Long deptId) {
        if (this.deptService.selectDeptCount(deptId) > 0) {
            return AjaxResult.warn((String)"\u5b58\u5728\u4e0b\u7ea7\u90e8\u95e8,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.deptService.checkDeptExistUser(deptId)) {
            return AjaxResult.warn((String)"\u90e8\u95e8\u5b58\u5728\u7528\u6237,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.toAjax(this.deptService.deleteDeptById(deptId));
    }

    @PostMapping(value={"/checkDeptNameUnique"})
    @ResponseBody
    public String checkDeptNameUnique(Dept dept) {
        return this.deptService.checkDeptNameUnique(dept);
    }

    @GetMapping(value={"/selectDeptTree/{deptId}", "/selectDeptTree/{deptId}/{excludeId}"})
    public String selectDeptTree(@PathVariable(value="deptId") Long deptId, @PathVariable(value="excludeId", required=false) String excludeId, ModelMap mmap) {
        mmap.put((Object)"dept", (Object)this.deptService.selectDeptById(deptId));
        mmap.put((Object)"excludeId", (Object)excludeId);
        return this.prefix + "/tree";
    }

    @GetMapping(value={"/treeData"})
    @ResponseBody
    public List<Ztree> treeData() {
        List ztrees = this.deptService.selectDeptTree(new Dept());
        return ztrees;
    }

    @GetMapping(value={"/treeData/{excludeId}"})
    @ResponseBody
    public List<Ztree> treeDataExcludeChild(@PathVariable(value="excludeId", required=false) Long excludeId) {
        Dept dept = new Dept();
        dept.setExcludeId(excludeId);
        List ztrees = this.deptService.selectDeptTreeExcludeChild(dept);
        return ztrees;
    }

    @GetMapping(value={"/roleDeptTreeData"})
    @ResponseBody
    public List<Ztree> deptTreeData(Role role) {
        List ztrees = this.deptService.roleDeptTreeData(role);
        return ztrees;
    }
}

