/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.config.service;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.CacheUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.project.system.config.domain.Config;
import com.ruoyi.project.system.config.mapper.ConfigMapper;
import com.ruoyi.project.system.config.service.IConfigService;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigServiceImpl
implements IConfigService {
    @Autowired
    private ConfigMapper configMapper;

    @PostConstruct
    public void init() {
        this.loadingConfigCache();
    }

    public Config selectConfigById(Long configId) {
        Config config = new Config();
        config.setConfigId(configId);
        return this.configMapper.selectConfig(config);
    }

    public String selectConfigByKey(String configKey) {
        String configValue = Convert.toStr((Object)CacheUtils.get((String)this.getCacheName(), (String)this.getCacheKey(configKey)));
        if (StringUtils.isNotEmpty((String)configValue)) {
            return configValue;
        }
        Config config = new Config();
        config.setConfigKey(configKey);
        Config retConfig = this.configMapper.selectConfig(config);
        if (StringUtils.isNotNull((Object)retConfig)) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(configKey), (Object)retConfig.getConfigValue());
            return retConfig.getConfigValue();
        }
        return "";
    }

    public List<Config> selectConfigList(Config config) {
        return this.configMapper.selectConfigList(config);
    }

    public int insertConfig(Config config) {
        config.setCreateBy(ShiroUtils.getLoginName());
        int row = this.configMapper.insertConfig(config);
        if (row > 0) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    public int updateConfig(Config config) {
        config.setUpdateBy(ShiroUtils.getLoginName());
        int row = this.configMapper.updateConfig(config);
        if (row > 0) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    public int updateConfigNoShiro(Config config) {
        int row = this.configMapper.updateConfig(config);
        if (row > 0) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    public void deleteConfigByIds(String ids) {
        Long[] configIds;
        for (Long configId : configIds = Convert.toLongArray((String)ids)) {
            Config config = this.selectConfigById(configId);
            if (StringUtils.equals((CharSequence)"Y", (CharSequence)config.getConfigType())) {
                throw new ServiceException(String.format("\u5185\u7f6e\u53c2\u6570\u3010%1$s\u3011\u4e0d\u80fd\u5220\u9664 ", config.getConfigKey()));
            }
            this.configMapper.deleteConfigById(configId);
            CacheUtils.remove((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()));
        }
    }

    public void loadingConfigCache() {
        List configsList = this.configMapper.selectConfigList(new Config());
        for (Config config : configsList) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
    }

    public void clearConfigCache() {
        CacheUtils.removeAll((String)this.getCacheName());
    }

    public void resetConfigCache() {
        this.clearConfigCache();
        this.loadingConfigCache();
    }

    public String checkConfigKeyUnique(Config config) {
        Long configId = StringUtils.isNull((Object)config.getConfigId()) ? -1L : config.getConfigId();
        Config info = this.configMapper.checkConfigKeyUnique(config.getConfigKey());
        if (StringUtils.isNotNull((Object)info) && info.getConfigId().longValue() != configId.longValue()) {
            return "1";
        }
        return "0";
    }

    private String getCacheName() {
        return "sys-config";
    }

    private String getCacheKey(String configKey) {
        return "sys_config:" + configKey;
    }
}

