/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.system.config.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.system.config.domain.Config;
import com.ruoyi.project.system.config.service.IConfigService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/config"})
public class ConfigController
extends BaseController {
    private String prefix = "system/config";
    @Autowired
    private IConfigService configService;

    @RequiresPermissions(value={"system:config:view"})
    @GetMapping
    public String config() {
        return this.prefix + "/config";
    }

    @RequiresPermissions(value={"system:config:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(Config config) {
        this.startPage();
        List list = this.configService.selectConfigList(config);
        return this.getDataTable(list);
    }

    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:config:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(Config config) {
        List list = this.configService.selectConfigList(config);
        ExcelUtil util = new ExcelUtil(Config.class);
        return util.exportExcel(list, "\u53c2\u6570\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:config:add"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated Config config) {
        if ("1".equals(this.configService.checkConfigKeyUnique(config))) {
            return this.error("\u65b0\u589e\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        return this.toAjax(this.configService.insertConfig(config));
    }

    @GetMapping(value={"/edit/{configId}"})
    public String edit(@PathVariable(value="configId") Long configId, ModelMap mmap) {
        mmap.put((Object)"config", (Object)this.configService.selectConfigById(configId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:config:edit"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated Config config) {
        if ("1".equals(this.configService.checkConfigKeyUnique(config))) {
            return this.error("\u4fee\u6539\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        return this.toAjax(this.configService.updateConfig(config));
    }

    @RequiresPermissions(value={"system:config:remove"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        this.configService.deleteConfigByIds(ids);
        return this.success();
    }

    @RequiresPermissions(value={"system:config:remove"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.CLEAN)
    @GetMapping(value={"/refreshCache"})
    @ResponseBody
    public AjaxResult refreshCache() {
        this.configService.resetConfigCache();
        return this.success();
    }

    @PostMapping(value={"/checkConfigKeyUnique"})
    @ResponseBody
    public String checkConfigKeyUnique(Config config) {
        return this.configService.checkConfigKeyUnique(config);
    }
}

