/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.operlog.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.monitor.operlog.domain.OperLog;
import com.ruoyi.project.monitor.operlog.service.IOperLogService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/operlog"})
public class OperlogController
extends BaseController {
    private String prefix = "monitor/operlog";
    @Autowired
    private IOperLogService operLogService;

    @RequiresPermissions(value={"monitor:operlog:view"})
    @GetMapping
    public String operlog() {
        return this.prefix + "/operlog";
    }

    @RequiresPermissions(value={"monitor:operlog:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(OperLog operLog) {
        this.startPage();
        List list = this.operLogService.selectOperLogList(operLog);
        return this.getDataTable(list);
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:operlog:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(OperLog operLog) {
        List list = this.operLogService.selectOperLogList(operLog);
        ExcelUtil util = new ExcelUtil(OperLog.class);
        return util.exportExcel(list, "\u64cd\u4f5c\u65e5\u5fd7");
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"monitor:operlog:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.operLogService.deleteOperLogByIds(ids));
    }

    @RequiresPermissions(value={"monitor:operlog:detail"})
    @GetMapping(value={"/detail/{operId}"})
    public String detail(@PathVariable(value="operId") Long operId, ModelMap mmap) {
        mmap.put((Object)"operLog", (Object)this.operLogService.selectOperLogById(operId));
        return this.prefix + "/detail";
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @RequiresPermissions(value={"monitor:operlog:remove"})
    @PostMapping(value={"/clean"})
    @ResponseBody
    public AjaxResult clean() {
        this.operLogService.cleanOperLog();
        return this.success();
    }
}

