/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.online.service;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.shiro.session.OnlineSessionDAO;
import com.ruoyi.project.monitor.online.domain.UserOnline;
import com.ruoyi.project.monitor.online.mapper.UserOnlineMapper;
import com.ruoyi.project.monitor.online.service.IUserOnlineService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserOnlineServiceImpl
implements IUserOnlineService {
    @Autowired
    private UserOnlineMapper userOnlineDao;
    @Autowired
    private OnlineSessionDAO onlineSessionDAO;
    @Autowired
    private EhCacheManager ehCacheManager;

    public UserOnline selectOnlineById(String sessionId) {
        return this.userOnlineDao.selectOnlineById(sessionId);
    }

    public void deleteOnlineById(String sessionId) {
        UserOnline userOnline = this.selectOnlineById(sessionId);
        if (StringUtils.isNotNull((Object)userOnline)) {
            this.userOnlineDao.deleteOnlineById(sessionId);
        }
    }

    public void batchDeleteOnline(List<String> sessions) {
        for (String sessionId : sessions) {
            UserOnline userOnline = this.selectOnlineById(sessionId);
            if (!StringUtils.isNotNull((Object)userOnline)) continue;
            this.userOnlineDao.deleteOnlineById(sessionId);
        }
    }

    public void saveOnline(UserOnline online) {
        this.userOnlineDao.saveOnline(online);
    }

    public List<UserOnline> selectUserOnlineList(UserOnline userOnline) {
        return this.userOnlineDao.selectUserOnlineList(userOnline);
    }

    public void forceLogout(String sessionId) {
        Session session = this.onlineSessionDAO.readSession((Serializable)((Object)sessionId));
        if (session == null) {
            return;
        }
        session.setTimeout(1000L);
        this.userOnlineDao.deleteOnlineById(sessionId);
    }

    public void removeUserCache(String loginName, String sessionId) {
        Cache cache = this.ehCacheManager.getCache("sys-userCache");
        Deque deque = (Deque)cache.get((Object)loginName);
        if (StringUtils.isEmpty((Collection)deque) || deque.size() == 0) {
            return;
        }
        deque.remove(sessionId);
    }

    public List<UserOnline> selectOnlineByExpired(Date expiredDate) {
        String lastAccessTime = DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (Date)expiredDate);
        return this.userOnlineDao.selectOnlineByExpired(lastAccessTime);
    }
}

