/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.online.controller;

import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.shiro.session.OnlineSessionDAO;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.monitor.online.domain.OnlineSession;
import com.ruoyi.project.monitor.online.domain.UserOnline;
import com.ruoyi.project.monitor.online.service.IUserOnlineService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/online"})
public class UserOnlineController
extends BaseController {
    private String prefix = "monitor/online";
    @Autowired
    private IUserOnlineService userOnlineService;
    @Autowired
    private OnlineSessionDAO onlineSessionDAO;

    @RequiresPermissions(value={"monitor:online:view"})
    @GetMapping
    public String online() {
        return this.prefix + "/online";
    }

    @RequiresPermissions(value={"monitor:online:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(UserOnline userOnline) {
        this.startPage();
        List list = this.userOnlineService.selectUserOnlineList(userOnline);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"monitor:online:batchForceLogout", "monitor:online:forceLogout"}, logical=Logical.OR)
    @Log(title="\u5728\u7ebf\u7528\u6237", businessType=BusinessType.FORCE)
    @PostMapping(value={"/batchForceLogout"})
    @ResponseBody
    public AjaxResult batchForceLogout(String ids) {
        for (String sessionId : Convert.toStrArray((String)ids)) {
            UserOnline online = this.userOnlineService.selectOnlineById(sessionId);
            if (online == null) {
                return this.error("\u7528\u6237\u5df2\u4e0b\u7ebf");
            }
            OnlineSession onlineSession = (OnlineSession)this.onlineSessionDAO.readSession((Serializable)((Object)online.getSessionId()));
            if (onlineSession == null) {
                return this.error("\u7528\u6237\u5df2\u4e0b\u7ebf");
            }
            if (sessionId.equals(ShiroUtils.getSessionId())) {
                return this.error("\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u6cd5\u5f3a\u9000");
            }
            this.onlineSessionDAO.delete((Session)onlineSession);
            online.setStatus(OnlineSession.OnlineStatus.off_line);
            this.userOnlineService.saveOnline(online);
            this.userOnlineService.removeUserCache(online.getLoginName(), sessionId);
        }
        return this.success();
    }
}

