/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.job.util;

import com.ruoyi.common.constant.ScheduleConstants;
import com.ruoyi.common.exception.job.TaskException;
import com.ruoyi.project.monitor.job.util.QuartzDisallowConcurrentExecution;
import com.ruoyi.project.monitor.job.util.QuartzJobExecution;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScheduleUtils {
    private static Class<? extends Job> getQuartzJobClass(com.ruoyi.project.monitor.job.domain.Job job) {
        boolean isConcurrent = "0".equals(job.getConcurrent());
        return isConcurrent ? QuartzJobExecution.class : QuartzDisallowConcurrentExecution.class;
    }

    public static TriggerKey getTriggerKey(Long jobId, String jobGroup) {
        return TriggerKey.triggerKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }

    public static JobKey getJobKey(Long jobId, String jobGroup) {
        return JobKey.jobKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }

    public static void createScheduleJob(Scheduler scheduler, com.ruoyi.project.monitor.job.domain.Job job) throws SchedulerException, TaskException {
        Class jobClass = ScheduleUtils.getQuartzJobClass((com.ruoyi.project.monitor.job.domain.Job)job);
        Long jobId = job.getJobId();
        String jobGroup = job.getJobGroup();
        JobDetail jobDetail = JobBuilder.newJob((Class)jobClass).withIdentity(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup)).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
        cronScheduleBuilder = ScheduleUtils.handleCronScheduleMisfirePolicy((com.ruoyi.project.monitor.job.domain.Job)job, (CronScheduleBuilder)cronScheduleBuilder);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey((Long)jobId, (String)jobGroup)).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        jobDetail.getJobDataMap().put("TASK_PROPERTIES", (Object)job);
        if (scheduler.checkExists(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup))) {
            scheduler.deleteJob(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup));
        }
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        if (job.getStatus().equals(ScheduleConstants.Status.PAUSE.getValue())) {
            scheduler.pauseJob(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup));
        }
    }

    public static CronScheduleBuilder handleCronScheduleMisfirePolicy(com.ruoyi.project.monitor.job.domain.Job job, CronScheduleBuilder cb) throws TaskException {
        switch (job.getMisfirePolicy()) {
            case "0": {
                return cb;
            }
            case "1": {
                return cb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case "2": {
                return cb.withMisfireHandlingInstructionFireAndProceed();
            }
            case "3": {
                return cb.withMisfireHandlingInstructionDoNothing();
            }
        }
        throw new TaskException("The task misfire policy '" + job.getMisfirePolicy() + "' cannot be used in cron schedule tasks", TaskException.Code.CONFIG_ERROR);
    }
}

