/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.job.util;

import com.ruoyi.common.utils.ExceptionUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.project.monitor.job.domain.JobLog;
import com.ruoyi.project.monitor.job.service.IJobLogService;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractQuartzJob.class);
    private static ThreadLocal<Date> threadLocal = new ThreadLocal();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        com.ruoyi.project.monitor.job.domain.Job job = new com.ruoyi.project.monitor.job.domain.Job();
        BeanUtils.copyBeanProp((Object)job, (Object)context.getMergedJobDataMap().get((Object)"TASK_PROPERTIES"));
        try {
            this.before(context, job);
            if (job != null) {
                this.doExecute(context, job);
            }
            this.after(context, job, null);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38  - \uff1a", (Throwable)e);
            this.after(context, job, e);
        }
    }

    protected void before(JobExecutionContext context, com.ruoyi.project.monitor.job.domain.Job job) {
        threadLocal.set(new Date());
    }

    protected void after(JobExecutionContext context, com.ruoyi.project.monitor.job.domain.Job job, Exception e) {
        Date startTime = (Date)threadLocal.get();
        threadLocal.remove();
        JobLog jobLog = new JobLog();
        jobLog.setJobName(job.getJobName());
        jobLog.setJobGroup(job.getJobGroup());
        jobLog.setInvokeTarget(job.getInvokeTarget());
        jobLog.setStartTime(startTime);
        jobLog.setEndTime(new Date());
        long runMs = jobLog.getEndTime().getTime() - jobLog.getStartTime().getTime();
        jobLog.setJobMessage(jobLog.getJobName() + " \u603b\u5171\u8017\u65f6\uff1a" + runMs + "\u6beb\u79d2");
        if (e != null) {
            jobLog.setStatus("1");
            String errorMsg = StringUtils.substring((String)ExceptionUtil.getExceptionMessage((Throwable)e), (int)0, (int)2000);
            jobLog.setExceptionInfo(errorMsg);
        } else {
            jobLog.setStatus("0");
        }
        ((IJobLogService)SpringUtils.getBean(IJobLogService.class)).addJobLog(jobLog);
    }

    protected abstract void doExecute(JobExecutionContext var1, com.ruoyi.project.monitor.job.domain.Job var2) throws Exception;
}

