/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.job.service;

import com.ruoyi.common.constant.ScheduleConstants;
import com.ruoyi.common.exception.job.TaskException;
import com.ruoyi.common.utils.text.Convert;
import com.ruoyi.project.monitor.job.domain.Job;
import com.ruoyi.project.monitor.job.mapper.JobMapper;
import com.ruoyi.project.monitor.job.service.IJobService;
import com.ruoyi.project.monitor.job.util.CronUtils;
import com.ruoyi.project.monitor.job.util.ScheduleUtils;
import java.util.List;
import javax.annotation.PostConstruct;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobServiceImpl
implements IJobService {
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private JobMapper jobMapper;

    @PostConstruct
    public void init() throws SchedulerException, TaskException {
        this.scheduler.clear();
        List jobList = this.jobMapper.selectJobAll();
        for (Job job : jobList) {
            ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (Job)job);
        }
    }

    public List<Job> selectJobList(Job job) {
        return this.jobMapper.selectJobList(job);
    }

    public Job selectJobById(Long jobId) {
        return this.jobMapper.selectJobById(jobId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int pauseJob(Job job) throws SchedulerException {
        Long jobId = job.getJobId();
        String jobGroup = job.getJobGroup();
        job.setStatus(ScheduleConstants.Status.PAUSE.getValue());
        int rows = this.jobMapper.updateJob(job);
        if (rows > 0) {
            this.scheduler.pauseJob(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup));
        }
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public int resumeJob(Job job) throws SchedulerException {
        Long jobId = job.getJobId();
        String jobGroup = job.getJobGroup();
        job.setStatus(ScheduleConstants.Status.NORMAL.getValue());
        int rows = this.jobMapper.updateJob(job);
        if (rows > 0) {
            this.scheduler.resumeJob(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup));
        }
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteJob(Job job) throws SchedulerException {
        Long jobId = job.getJobId();
        String jobGroup = job.getJobGroup();
        int rows = this.jobMapper.deleteJobById(jobId);
        if (rows > 0) {
            this.scheduler.deleteJob(ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup));
        }
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteJobByIds(String ids) throws SchedulerException {
        Long[] jobIds;
        for (Long jobId : jobIds = Convert.toLongArray((String)ids)) {
            Job job = this.jobMapper.selectJobById(jobId);
            this.deleteJob(job);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int changeStatus(Job job) throws SchedulerException {
        int rows = 0;
        String status = job.getStatus();
        if (ScheduleConstants.Status.NORMAL.getValue().equals(status)) {
            rows = this.resumeJob(job);
        } else if (ScheduleConstants.Status.PAUSE.getValue().equals(status)) {
            rows = this.pauseJob(job);
        }
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(Job job) throws SchedulerException {
        Long jobId = job.getJobId();
        Job tmpObj = this.selectJobById(job.getJobId());
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("TASK_PROPERTIES", (Object)tmpObj);
        this.scheduler.triggerJob(ScheduleUtils.getJobKey((Long)jobId, (String)tmpObj.getJobGroup()), dataMap);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertJob(Job job) throws SchedulerException, TaskException {
        job.setStatus(ScheduleConstants.Status.PAUSE.getValue());
        int rows = this.jobMapper.insertJob(job);
        if (rows > 0) {
            ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (Job)job);
        }
        return rows;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateJob(Job job) throws SchedulerException, TaskException {
        Job properties = this.selectJobById(job.getJobId());
        int rows = this.jobMapper.updateJob(job);
        if (rows > 0) {
            this.updateSchedulerJob(job, properties.getJobGroup());
        }
        return rows;
    }

    public void updateSchedulerJob(Job job, String jobGroup) throws SchedulerException, TaskException {
        Long jobId = job.getJobId();
        JobKey jobKey = ScheduleUtils.getJobKey((Long)jobId, (String)jobGroup);
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
        ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (Job)job);
    }

    public boolean checkCronExpressionIsValid(String cronExpression) {
        return CronUtils.isValid((String)cronExpression);
    }
}

