/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.job.controller;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.monitor.job.domain.Job;
import com.ruoyi.project.monitor.job.domain.JobLog;
import com.ruoyi.project.monitor.job.service.IJobLogService;
import com.ruoyi.project.monitor.job.service.IJobService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/jobLog"})
public class JobLogController
extends BaseController {
    private String prefix = "monitor/job";
    @Autowired
    private IJobService jobService;
    @Autowired
    private IJobLogService jobLogService;

    @RequiresPermissions(value={"monitor:job:view"})
    @GetMapping
    public String jobLog(@RequestParam(value="jobId", required=false) Long jobId, ModelMap mmap) {
        if (StringUtils.isNotNull((Object)jobId)) {
            Job job = this.jobService.selectJobById(jobId);
            mmap.put((Object)"job", (Object)job);
        }
        return this.prefix + "/jobLog";
    }

    @RequiresPermissions(value={"monitor:job:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(JobLog jobLog) {
        this.startPage();
        List list = this.jobLogService.selectJobLogList(jobLog);
        return this.getDataTable(list);
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:job:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(JobLog jobLog) {
        List list = this.jobLogService.selectJobLogList(jobLog);
        ExcelUtil util = new ExcelUtil(JobLog.class);
        return util.exportExcel(list, "\u8c03\u5ea6\u65e5\u5fd7");
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.jobLogService.deleteJobLogByIds(ids));
    }

    @RequiresPermissions(value={"monitor:job:detail"})
    @GetMapping(value={"/detail/{jobLogId}"})
    public String detail(@PathVariable(value="jobLogId") Long jobLogId, ModelMap mmap) {
        mmap.put((Object)"name", (Object)"jobLog");
        mmap.put((Object)"jobLog", (Object)this.jobLogService.selectJobLogById(jobLogId));
        return this.prefix + "/detail";
    }

    @Log(title="\u8c03\u5ea6\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/clean"})
    @ResponseBody
    public AjaxResult clean() {
        this.jobLogService.cleanJobLog();
        return this.success();
    }
}

