/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.job.controller;

import com.ruoyi.common.exception.job.TaskException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.monitor.job.domain.Job;
import com.ruoyi.project.monitor.job.service.IJobService;
import com.ruoyi.project.monitor.job.util.CronUtils;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/monitor/job"})
public class JobController
extends BaseController {
    private String prefix = "monitor/job";
    @Autowired
    private IJobService jobService;

    @RequiresPermissions(value={"monitor:job:view"})
    @GetMapping
    public String job() {
        return this.prefix + "/job";
    }

    @RequiresPermissions(value={"monitor:job:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(Job job) {
        this.startPage();
        List list = this.jobService.selectJobList(job);
        return this.getDataTable(list);
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:job:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(Job job) {
        List list = this.jobService.selectJobList(job);
        ExcelUtil util = new ExcelUtil(Job.class);
        return util.exportExcel(list, "\u5b9a\u65f6\u4efb\u52a1");
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) throws SchedulerException {
        this.jobService.deleteJobByIds(ids);
        return this.success();
    }

    @RequiresPermissions(value={"monitor:job:detail"})
    @GetMapping(value={"/detail/{jobId}"})
    public String detail(@PathVariable(value="jobId") Long jobId, ModelMap mmap) {
        mmap.put((Object)"name", (Object)"job");
        mmap.put((Object)"job", (Object)this.jobService.selectJobById(jobId));
        return this.prefix + "/detail";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:changeStatus"})
    @PostMapping(value={"/changeStatus"})
    @ResponseBody
    public AjaxResult changeStatus(Job job) throws SchedulerException {
        Job newJob = this.jobService.selectJobById(job.getJobId());
        newJob.setStatus(job.getStatus());
        return this.toAjax(this.jobService.changeStatus(newJob));
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:changeStatus"})
    @PostMapping(value={"/run"})
    @ResponseBody
    public AjaxResult run(Job job) throws SchedulerException {
        this.jobService.run(job);
        return this.success();
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"monitor:job:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated Job job) throws SchedulerException, TaskException {
        if (!CronUtils.isValid((String)job.getCronExpression())) {
            return this.error("\u65b0\u589e\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0cCron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StringUtils.containsIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence)"rmi://")) {
            return this.error("\u65b0\u589e\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'rmi://'\u8c03\u7528");
        }
        if (StringUtils.containsIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence)"ldap://")) {
            return this.error("\u65b0\u589e\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'ldap://'\u8c03\u7528");
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence[])new String[]{"http://", "https://"})) {
            return this.error("\u65b0\u589e\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'http(s)//'\u8c03\u7528");
        }
        job.setCreateBy(this.getLoginName());
        return this.toAjax(this.jobService.insertJob(job));
    }

    @GetMapping(value={"/edit/{jobId}"})
    public String edit(@PathVariable(value="jobId") Long jobId, ModelMap mmap) {
        mmap.put((Object)"job", (Object)this.jobService.selectJobById(jobId));
        return this.prefix + "/edit";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated Job job) throws SchedulerException, TaskException {
        if (!CronUtils.isValid((String)job.getCronExpression())) {
            return this.error("\u4fee\u6539\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0cCron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StringUtils.containsIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence)"rmi://")) {
            return this.error("\u4fee\u6539\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'rmi://'\u8c03\u7528");
        }
        if (StringUtils.containsIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence)"ldap://")) {
            return this.error("\u4fee\u6539\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'ldap://'\u8c03\u7528");
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)job.getInvokeTarget(), (CharSequence[])new String[]{"http://", "https://"})) {
            return this.error("\u4fee\u6539\u4efb\u52a1'" + job.getJobName() + "'\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u7b26\u4e32\u4e0d\u5141\u8bb8'http(s)//'\u8c03\u7528");
        }
        job.setUpdateBy(this.getLoginName());
        return this.toAjax(this.jobService.updateJob(job));
    }

    @PostMapping(value={"/checkCronExpressionIsValid"})
    @ResponseBody
    public boolean checkCronExpressionIsValid(Job job) {
        return this.jobService.checkCronExpressionIsValid(job.getCronExpression());
    }

    @GetMapping(value={"/cron"})
    public String cron() {
        return this.prefix + "/cron";
    }

    @GetMapping(value={"/queryCronExpression"})
    @ResponseBody
    public AjaxResult queryCronExpression(@RequestParam(value="cronExpression", required=false) String cronExpression) {
        if (this.jobService.checkCronExpressionIsValid(cronExpression)) {
            List dateList = CronUtils.getRecentTriggerTime((String)cronExpression);
            return JobController.success((Object)dateList);
        }
        return this.error("\u8868\u8fbe\u5f0f\u65e0\u6548");
    }
}

