/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.monitor.cache;

import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.service.CacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/cache"})
public class CacheController
extends BaseController {
    private String prefix = "monitor/cache";
    @Autowired
    private CacheService cacheService;

    @GetMapping
    public String cache(ModelMap mmap) {
        mmap.put((Object)"cacheNames", (Object)this.cacheService.getCacheNames());
        return this.prefix + "/cache";
    }

    @PostMapping(value={"/getNames"})
    public String getCacheNames(String fragment, ModelMap mmap) {
        mmap.put((Object)"cacheNames", (Object)this.cacheService.getCacheNames());
        return this.prefix + "/cache::" + fragment;
    }

    @PostMapping(value={"/getKeys"})
    public String getCacheKeys(String fragment, String cacheName, ModelMap mmap) {
        mmap.put((Object)"cacheName", (Object)cacheName);
        mmap.put((Object)"cacheKyes", (Object)this.cacheService.getCacheKeys(cacheName));
        return this.prefix + "/cache::" + fragment;
    }

    @PostMapping(value={"/getValue"})
    public String getCacheValue(String fragment, String cacheName, String cacheKey, ModelMap mmap) {
        mmap.put((Object)"cacheName", (Object)cacheName);
        mmap.put((Object)"cacheKey", (Object)cacheKey);
        mmap.put((Object)"cacheValue", this.cacheService.getCacheValue(cacheName, cacheKey));
        return this.prefix + "/cache::" + fragment;
    }

    @PostMapping(value={"/clearCacheName"})
    @ResponseBody
    public AjaxResult clearCacheName(String cacheName, ModelMap mmap) {
        this.cacheService.clearCacheName(cacheName);
        return AjaxResult.success();
    }

    @PostMapping(value={"/clearCacheKey"})
    @ResponseBody
    public AjaxResult clearCacheKey(String cacheName, String cacheKey, ModelMap mmap) {
        this.cacheService.clearCacheKey(cacheName, cacheKey);
        return AjaxResult.success();
    }

    @GetMapping(value={"/clearAll"})
    @ResponseBody
    public AjaxResult clearAll(ModelMap mmap) {
        this.cacheService.clearAll();
        return AjaxResult.success();
    }
}

