/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.web.exception;

import com.ruoyi.common.exception.DemoModeException;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.security.PermissionUtils;
import com.ruoyi.framework.web.domain.AjaxResult;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AuthorizationException.class})
    public Object handleAuthorizationException(AuthorizationException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u6743\u9650\u6821\u9a8c\u5931\u8d25'{}'", (Object)requestURI, (Object)e.getMessage());
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            return AjaxResult.error((String)PermissionUtils.getMsg((String)e.getMessage()));
        }
        return new ModelAndView("error/unauth");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AjaxResult handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public AjaxResult handleRuntimeException(RuntimeException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u672a\u77e5\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public Object handleServiceException(ServiceException e, HttpServletRequest request) {
        log.error(e.getMessage(), (Throwable)e);
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            return AjaxResult.error((String)e.getMessage());
        }
        return new ModelAndView("error/service", "errorMessage", (Object)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult handleBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={DemoModeException.class})
    public AjaxResult handleDemoModeException(DemoModeException e) {
        return AjaxResult.error((String)"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
    }
}

