/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.web.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.sql.SqlUtil;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.PageDomain;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.framework.web.page.TableSupport;
import com.ruoyi.project.system.user.domain.User;
import java.beans.PropertyEditor;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (StringUtils.isNotNull((Object)pageNum) && StringUtils.isNotNull((Object)pageSize)) {
            String orderBy = SqlUtil.escapeOrderBySql((String)pageDomain.getOrderBy());
            PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy);
        }
    }

    protected void startOrderBy() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        if (StringUtils.isNotEmpty((String)pageDomain.getOrderBy())) {
            String orderBy = SqlUtil.escapeOrderBySql((String)pageDomain.getOrderBy());
            PageHelper.orderBy((String)orderBy);
        }
    }

    protected TableDataInfo getDataTable(List<?> list) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(list);
        rspData.setTotal(new PageInfo(list).getTotal());
        return rspData;
    }

    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? this.success() : this.error();
    }

    protected AjaxResult toAjax(boolean result) {
        return result ? this.success() : this.error();
    }

    public AjaxResult success() {
        return AjaxResult.success();
    }

    public AjaxResult error() {
        return AjaxResult.error();
    }

    public AjaxResult success(String message) {
        return AjaxResult.success((String)message);
    }

    public static AjaxResult success(Object data) {
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)data);
    }

    public AjaxResult error(String message) {
        return AjaxResult.error((String)message);
    }

    public AjaxResult error(AjaxResult.Type type, String message) {
        return new AjaxResult(type, message);
    }

    public String redirect(String url) {
        return StringUtils.format((String)"redirect:{}", (Object[])new Object[]{url});
    }

    public User getSysUser() {
        return ShiroUtils.getSysUser();
    }

    public void setSysUser(User user) {
        ShiroUtils.setSysUser((User)user);
    }

    public Long getUserId() {
        return this.getSysUser().getUserId();
    }

    public String getLoginName() {
        return this.getSysUser().getLoginName();
    }
}

