/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.web.session;

import com.ruoyi.common.utils.Threads;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SpringSessionValidationScheduler
implements SessionValidationScheduler {
    private static final Logger log = LoggerFactory.getLogger(SpringSessionValidationScheduler.class);
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    @Autowired
    @Qualifier(value="scheduledExecutorService")
    private ScheduledExecutorService executorService;
    private volatile boolean enabled = false;
    @Autowired
    @Qualifier(value="sessionManager")
    @Lazy
    private ValidatingSessionManager sessionManager;
    @Value(value="${shiro.session.validationInterval}")
    private long sessionValidationInterval;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public void enableSessionValidation() {
        block4: {
            this.enabled = true;
            if (log.isDebugEnabled()) {
                log.debug("Scheduling session validation job using Spring Scheduler with session validation interval of [" + this.sessionValidationInterval + "]ms...");
            }
            try {
                this.executorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 1000L, this.sessionValidationInterval * 60L * 1000L, TimeUnit.MILLISECONDS);
                this.enabled = true;
                if (log.isDebugEnabled()) {
                    log.debug("Session validation job successfully scheduled with Spring Scheduler.");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error("Error starting the Spring Scheduler session validation job.  Session validation may not occur.", (Throwable)e);
            }
        }
    }

    public void disableSessionValidation() {
        if (log.isDebugEnabled()) {
            log.debug("Stopping Spring Scheduler session validation job...");
        }
        if (this.enabled) {
            Threads.shutdownAndAwaitTermination((ExecutorService)this.executorService);
        }
        this.enabled = false;
    }

    static /* synthetic */ boolean access$000(SpringSessionValidationScheduler x0) {
        return x0.enabled;
    }

    static /* synthetic */ ValidatingSessionManager access$100(SpringSessionValidationScheduler x0) {
        return x0.sessionManager;
    }
}

