/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.web.filter.online;

import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.shiro.session.OnlineSessionDAO;
import com.ruoyi.project.monitor.online.domain.OnlineSession;
import com.ruoyi.project.system.user.domain.User;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.beans.factory.annotation.Value;

public class OnlineSessionFilter
extends AccessControlFilter {
    @Value(value="${shiro.user.loginUrl}")
    private String loginUrl;
    private OnlineSessionDAO onlineSessionDAO;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (subject == null || subject.getSession() == null) {
            return true;
        }
        Session session = this.onlineSessionDAO.readSession(subject.getSession().getId());
        if (session != null && session instanceof OnlineSession) {
            User user;
            boolean isGuest;
            OnlineSession onlineSession = (OnlineSession)session;
            request.setAttribute("online_session", (Object)onlineSession);
            boolean bl = isGuest = onlineSession.getUserId() == null || onlineSession.getUserId() == 0L;
            if (isGuest && (user = ShiroUtils.getSysUser()) != null) {
                onlineSession.setUserId(user.getUserId());
                onlineSession.setLoginName(user.getLoginName());
                onlineSession.setAvatar(user.getAvatar());
                onlineSession.setDeptName(user.getDept().getDeptName());
                onlineSession.markAttributeChanged();
            }
            if (onlineSession.getStatus() == OnlineSession.OnlineStatus.off_line) {
                return false;
            }
        }
        return true;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (subject != null) {
            subject.logout();
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.loginUrl);
    }

    public void setOnlineSessionDAO(OnlineSessionDAO onlineSessionDAO) {
        this.onlineSessionDAO = onlineSessionDAO;
    }
}

