/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.web.filter.captcha;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.filter.AccessControlFilter;

public class CaptchaValidateFilter
extends AccessControlFilter {
    private boolean captchaEnabled = true;
    private String captchaType = "math";

    public void setCaptchaEnabled(boolean captchaEnabled) {
        this.captchaEnabled = captchaEnabled;
    }

    public void setCaptchaType(String captchaType) {
        this.captchaType = captchaType;
    }

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        request.setAttribute("captchaEnabled", (Object)this.captchaEnabled);
        request.setAttribute("captchaType", (Object)this.captchaType);
        return super.onPreHandle(request, response, mappedValue);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (!this.captchaEnabled || !"post".equals(httpServletRequest.getMethod().toLowerCase())) {
            return true;
        }
        return this.validateResponse(httpServletRequest, httpServletRequest.getParameter("validateCode"));
    }

    public boolean validateResponse(HttpServletRequest request, String validateCode) {
        Object obj = ShiroUtils.getSession().getAttribute((Object)"KAPTCHA_SESSION_KEY");
        String code = String.valueOf(obj != null ? obj : "");
        request.getSession().removeAttribute("KAPTCHA_SESSION_KEY");
        return !StringUtils.isEmpty((String)validateCode) && validateCode.equalsIgnoreCase(code);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        request.setAttribute("captcha", (Object)"captchaError");
        return true;
    }
}

