/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.web.filter;

import com.ruoyi.common.utils.MessageUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.manager.factory.AsyncFactory;
import com.ruoyi.project.monitor.online.service.UserOnlineServiceImpl;
import com.ruoyi.project.system.user.domain.User;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutFilter
extends org.apache.shiro.web.filter.authc.LogoutFilter {
    private static final Logger log = LoggerFactory.getLogger(LogoutFilter.class);
    private String loginUrl;

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        try {
            Subject subject = this.getSubject(request, response);
            String redirectUrl = this.getRedirectUrl(request, response, subject);
            try {
                User user = ShiroUtils.getSysUser();
                if (StringUtils.isNotNull((Object)user)) {
                    String loginName = user.getLoginName();
                    AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)loginName, (String)"Logout", (String)MessageUtils.message((String)"user.logout.success", (Object[])new Object[0]), (Object[])new Object[0]));
                    ((UserOnlineServiceImpl)SpringUtils.getBean(UserOnlineServiceImpl.class)).removeUserCache(loginName, ShiroUtils.getSessionId());
                }
                subject.logout();
            }
            catch (SessionException ise) {
                log.error("logout fail.", (Throwable)ise);
            }
            this.issueRedirect(request, response, redirectUrl);
        }
        catch (Exception e) {
            log.error("Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)e);
        }
        return false;
    }

    protected String getRedirectUrl(ServletRequest request, ServletResponse response, Subject subject) {
        String url = this.getLoginUrl();
        if (StringUtils.isNotEmpty((String)url)) {
            return url;
        }
        return super.getRedirectUrl(request, response, subject);
    }
}

