/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.session;

import com.ruoyi.common.utils.IpUtils;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.project.monitor.online.domain.OnlineSession;
import com.ruoyi.project.monitor.online.domain.UserOnline;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.web.session.mgt.WebSessionContext;
import org.springframework.stereotype.Component;

@Component
public class OnlineSessionFactory
implements SessionFactory {
    public Session createSession(UserOnline userOnline) {
        OnlineSession onlineSession = userOnline.getSession();
        if (StringUtils.isNotNull((Object)onlineSession) && onlineSession.getId() == null) {
            onlineSession.setId((Serializable)((Object)userOnline.getSessionId()));
        }
        return userOnline.getSession();
    }

    public Session createSession(SessionContext initData) {
        WebSessionContext sessionContext;
        HttpServletRequest request;
        OnlineSession session = new OnlineSession();
        if (initData != null && initData instanceof WebSessionContext && (request = (HttpServletRequest)(sessionContext = (WebSessionContext)initData).getServletRequest()) != null) {
            UserAgent userAgent = UserAgent.parseUserAgentString((String)ServletUtils.getRequest().getHeader("User-Agent"));
            String os = userAgent.getOperatingSystem().getName();
            String browser = userAgent.getBrowser().getName();
            session.setHost(IpUtils.getIpAddr((HttpServletRequest)request));
            session.setBrowser(browser);
            session.setOs(os);
        }
        return session;
    }
}

