/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.session;

import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.manager.factory.AsyncFactory;
import com.ruoyi.framework.shiro.session.OnlineSessionFactory;
import com.ruoyi.project.monitor.online.domain.OnlineSession;
import com.ruoyi.project.monitor.online.domain.UserOnline;
import com.ruoyi.project.monitor.online.service.IUserOnlineService;
import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class OnlineSessionDAO
extends EnterpriseCacheSessionDAO {
    @Value(value="${shiro.session.dbSyncPeriod}")
    private int dbSyncPeriod;
    private static final String LAST_SYNC_DB_TIMESTAMP = OnlineSessionDAO.class.getName() + "LAST_SYNC_DB_TIMESTAMP";
    @Autowired
    private IUserOnlineService onlineService;
    @Autowired
    private OnlineSessionFactory onlineSessionFactory;

    public OnlineSessionDAO() {
    }

    public OnlineSessionDAO(long expireTime) {
    }

    protected Session doReadSession(Serializable sessionId) {
        UserOnline userOnline = this.onlineService.selectOnlineById(String.valueOf(sessionId));
        if (userOnline == null) {
            return null;
        }
        return this.onlineSessionFactory.createSession(userOnline);
    }

    public void update(Session session) throws UnknownSessionException {
        super.update(session);
    }

    public void syncToDb(OnlineSession onlineSession) {
        Date lastSyncTimestamp = (Date)onlineSession.getAttribute((Object)LAST_SYNC_DB_TIMESTAMP);
        if (lastSyncTimestamp != null) {
            boolean isGuest;
            boolean needSync = true;
            long deltaTime = onlineSession.getLastAccessTime().getTime() - lastSyncTimestamp.getTime();
            if (deltaTime < (long)(this.dbSyncPeriod * 60 * 1000)) {
                needSync = false;
            }
            boolean bl = isGuest = onlineSession.getUserId() == null || onlineSession.getUserId() == 0L;
            if (!isGuest && onlineSession.isAttributeChanged()) {
                needSync = true;
            }
            if (!needSync) {
                return;
            }
        }
        onlineSession.setAttribute((Object)LAST_SYNC_DB_TIMESTAMP, (Object)onlineSession.getLastAccessTime());
        if (onlineSession.isAttributeChanged()) {
            onlineSession.resetAttributeChanged();
        }
        AsyncManager.me().execute(AsyncFactory.syncSessionToDb((OnlineSession)onlineSession));
    }

    protected void doDelete(Session session) {
        OnlineSession onlineSession = (OnlineSession)session;
        if (null == onlineSession) {
            return;
        }
        onlineSession.setStatus(OnlineSession.OnlineStatus.off_line);
        this.onlineService.deleteOnlineById(String.valueOf(onlineSession.getId()));
    }
}

