/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.service;

import com.ruoyi.common.exception.user.UserPasswordNotMatchException;
import com.ruoyi.common.exception.user.UserPasswordRetryLimitExceedException;
import com.ruoyi.common.utils.MessageUtils;
import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.manager.factory.AsyncFactory;
import com.ruoyi.project.system.user.domain.User;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PasswordService {
    @Autowired
    private CacheManager cacheManager;
    private Cache<String, AtomicInteger> loginRecordCache;
    @Value(value="${user.password.maxRetryCount}")
    private String maxRetryCount;

    @PostConstruct
    public void init() {
        this.loginRecordCache = this.cacheManager.getCache("loginRecordCache");
    }

    public void validate(User user, String password) {
        String loginName = user.getLoginName();
        AtomicInteger retryCount = (AtomicInteger)this.loginRecordCache.get((Object)loginName);
        if (retryCount == null) {
            retryCount = new AtomicInteger(0);
            this.loginRecordCache.put((Object)loginName, (Object)retryCount);
        }
        if (retryCount.incrementAndGet() > Integer.valueOf(this.maxRetryCount)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)loginName, (String)"Error", (String)MessageUtils.message((String)"user.password.retry.limit.exceed", (Object[])new Object[]{this.maxRetryCount}), (Object[])new Object[0]));
            throw new UserPasswordRetryLimitExceedException(Integer.valueOf(this.maxRetryCount).intValue());
        }
        if (!this.matches(user, password)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)loginName, (String)"Error", (String)MessageUtils.message((String)"user.password.retry.limit.count", (Object[])new Object[]{retryCount}), (Object[])new Object[0]));
            this.loginRecordCache.put((Object)loginName, (Object)retryCount);
            throw new UserPasswordNotMatchException();
        }
        this.clearLoginRecordCache(loginName);
    }

    public boolean matches(User user, String newPassword) {
        return user.getPassword().equals(this.encryptPassword(user.getLoginName(), newPassword, user.getSalt()));
    }

    public void clearLoginRecordCache(String loginName) {
        this.loginRecordCache.remove((Object)loginName);
    }

    public String encryptPassword(String loginName, String password, String salt) {
        return new Md5Hash((Object)(loginName + password + salt)).toHex();
    }

    public static void main(String[] args) {
        System.out.println(new PasswordService().encryptPassword("admin", "admin123", "111111"));
        System.out.println(new PasswordService().encryptPassword("ry", "admin123", "222222"));
    }
}

