/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.service;

import com.ruoyi.common.exception.user.CaptchaException;
import com.ruoyi.common.exception.user.UserBlockedException;
import com.ruoyi.common.exception.user.UserDeleteException;
import com.ruoyi.common.exception.user.UserNotExistsException;
import com.ruoyi.common.exception.user.UserPasswordNotMatchException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.MessageUtils;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.manager.factory.AsyncFactory;
import com.ruoyi.framework.shiro.service.PasswordService;
import com.ruoyi.project.system.user.domain.User;
import com.ruoyi.project.system.user.domain.UserStatus;
import com.ruoyi.project.system.user.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LoginService {
    @Autowired
    private PasswordService passwordService;
    @Autowired
    private IUserService userService;

    public User login(String username, String password) {
        if ("captchaError".equals(ServletUtils.getRequest().getAttribute("captcha"))) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.jcaptcha.error", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new CaptchaException();
        }
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"not.null", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new UserNotExistsException();
        }
        if (password.length() < 5 || password.length() > 20) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.password.not.match", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new UserPasswordNotMatchException();
        }
        if (username.length() < 2 || username.length() > 20) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.password.not.match", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new UserPasswordNotMatchException();
        }
        User user = this.userService.selectUserByLoginName(username);
        if (user == null) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.not.exists", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new UserNotExistsException();
        }
        if (UserStatus.DELETED.getCode().equals(user.getDelFlag())) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.password.delete", (Object[])new Object[0]), (Object[])new Object[0]));
            throw new UserDeleteException();
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Error", (String)MessageUtils.message((String)"user.blocked", (Object[])new Object[]{user.getRemark()}), (Object[])new Object[0]));
            throw new UserBlockedException();
        }
        this.passwordService.validate(user, password);
        AsyncManager.me().execute(AsyncFactory.recordLogininfor((String)username, (String)"Success", (String)MessageUtils.message((String)"user.login.success", (Object[])new Object[0]), (Object[])new Object[0]));
        this.recordLoginInfo(user);
        return user;
    }

    public void recordLoginInfo(User user) {
        user.setLoginIp(ShiroUtils.getIp());
        user.setLoginDate(DateUtils.getNowDate());
        this.userService.updateUserInfo(user);
    }
}

