/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.shiro.realm;

import com.ruoyi.common.exception.user.CaptchaException;
import com.ruoyi.common.exception.user.RoleBlockedException;
import com.ruoyi.common.exception.user.UserBlockedException;
import com.ruoyi.common.exception.user.UserNotExistsException;
import com.ruoyi.common.exception.user.UserPasswordNotMatchException;
import com.ruoyi.common.exception.user.UserPasswordRetryLimitExceedException;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.shiro.service.LoginService;
import com.ruoyi.project.system.menu.service.IMenuService;
import com.ruoyi.project.system.role.service.IRoleService;
import com.ruoyi.project.system.user.domain.User;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(UserRealm.class);
    @Autowired
    private IMenuService menuService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private LoginService loginService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection arg0) {
        User user = ShiroUtils.getSysUser();
        Set roles = new HashSet();
        Set menus = new HashSet();
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        if (user.isAdmin()) {
            info.addRole("admin");
            info.addStringPermission("*:*:*");
        } else {
            roles = this.roleService.selectRoleKeys(user.getUserId());
            menus = this.menuService.selectPermsByUserId(user.getUserId());
            info.setRoles(roles);
            info.setStringPermissions(menus);
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        String password = "";
        if (upToken.getPassword() != null) {
            password = new String(upToken.getPassword());
        }
        User user = null;
        try {
            user = this.loginService.login(username, password);
        }
        catch (CaptchaException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (UserNotExistsException e) {
            throw new UnknownAccountException(e.getMessage(), (Throwable)e);
        }
        catch (UserPasswordNotMatchException e) {
            throw new IncorrectCredentialsException(e.getMessage(), (Throwable)e);
        }
        catch (UserPasswordRetryLimitExceedException e) {
            throw new ExcessiveAttemptsException(e.getMessage(), (Throwable)e);
        }
        catch (UserBlockedException e) {
            throw new LockedAccountException(e.getMessage(), (Throwable)e);
        }
        catch (RoleBlockedException e) {
            throw new LockedAccountException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.info("\u5bf9\u7528\u6237[" + username + "]\u8fdb\u884c\u767b\u5f55\u9a8c\u8bc1..\u9a8c\u8bc1\u672a\u901a\u8fc7{}", (Object)e.getMessage());
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user, (Object)password, this.getName());
        return info;
    }

    public void clearCachedAuthorizationInfo(Object principal) {
        SimplePrincipalCollection principals = new SimplePrincipalCollection(principal, this.getName());
        this.clearCachedAuthorizationInfo((PrincipalCollection)principals);
    }

    public void clearAllCachedAuthorizationInfo() {
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            for (Object key : cache.keys()) {
                cache.remove(key);
            }
        }
    }
}

