/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.manager;

import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.shiro.web.session.SpringSessionValidationScheduler;
import javax.annotation.PreDestroy;
import net.sf.ehcache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"sys-user");
    @Autowired(required=false)
    private SpringSessionValidationScheduler springSessionValidationScheduler;
    @Autowired(required=false)
    private EhCacheManager ehCacheManager;

    @PreDestroy
    public void destroy() {
        this.shutdownSpringSessionValidationScheduler();
        this.shutdownAsyncManager();
        this.shutdownEhCacheManager();
    }

    private void shutdownSpringSessionValidationScheduler() {
        if (this.springSessionValidationScheduler != null && this.springSessionValidationScheduler.isEnabled()) {
            try {
                logger.info("====\u5173\u95ed\u4f1a\u8bdd\u9a8c\u8bc1\u4efb\u52a1====");
                this.springSessionValidationScheduler.disableSessionValidation();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void shutdownAsyncManager() {
        try {
            logger.info("====\u5173\u95ed\u540e\u53f0\u4efb\u52a1\u4efb\u52a1\u7ebf\u7a0b\u6c60====");
            AsyncManager.me().shutdown();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void shutdownEhCacheManager() {
        try {
            logger.info("====\u5173\u95ed\u7f13\u5b58====");
            if (this.ehCacheManager != null) {
                CacheManager cacheManager = this.ehCacheManager.getCacheManager();
                cacheManager.shutdown();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

