/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.alibaba.druid.spring.boot.autoconfigure.properties.DruidStatProperties;
import com.ruoyi.common.utils.spring.SpringUtils;
import com.ruoyi.framework.aspectj.lang.enums.DataSourceType;
import com.ruoyi.framework.config.DruidConfig;
import com.ruoyi.framework.config.properties.DruidProperties;
import com.ruoyi.framework.datasource.DynamicDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DruidConfig {
    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.master")
    public DataSource masterDataSource(DruidProperties druidProperties) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        return druidProperties.dataSource(dataSource);
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.slave")
    @ConditionalOnProperty(prefix="spring.datasource.druid.slave", name={"enabled"}, havingValue="true")
    public DataSource slaveDataSource(DruidProperties druidProperties) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        return druidProperties.dataSource(dataSource);
    }

    @Bean(name={"dynamicDataSource"})
    @Primary
    public DynamicDataSource dataSource(DataSource masterDataSource) {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        targetDataSources.put(DataSourceType.MASTER.name(), masterDataSource);
        this.setDataSource(targetDataSources, DataSourceType.SLAVE.name(), "slaveDataSource");
        return new DynamicDataSource(masterDataSource, targetDataSources);
    }

    public void setDataSource(Map<Object, Object> targetDataSources, String sourceName, String beanName) {
        try {
            DataSource dataSource = (DataSource)SpringUtils.getBean((String)beanName);
            targetDataSources.put(sourceName, dataSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Bean
    @ConditionalOnProperty(name={"spring.datasource.druid.statViewServlet.enabled"}, havingValue="true")
    public FilterRegistrationBean removeDruidFilterRegistrationBean(DruidStatProperties properties) {
        DruidStatProperties.StatViewServlet config = properties.getStatViewServlet();
        String pattern = config.getUrlPattern() != null ? config.getUrlPattern() : "/druid/*";
        String commonJsPattern = pattern.replaceAll("\\*", "js/common.js");
        String filePath = "support/http/resources/js/common.js";
        1 filter = new /* Unavailable Anonymous Inner Class!! */;
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)filter);
        registrationBean.addUrlPatterns(new String[]{commonJsPattern});
        return registrationBean;
    }
}

