/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.aspectj;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessStatus;
import com.ruoyi.framework.manager.AsyncManager;
import com.ruoyi.framework.manager.factory.AsyncFactory;
import com.ruoyi.project.monitor.operlog.domain.OperLog;
import com.ruoyi.project.system.user.domain.User;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    public static final String[] EXCLUDE_PROPERTIES = new String[]{"password", "oldPassword", "newPassword", "confirmPassword"};

    @Pointcut(value="@annotation(com.ruoyi.framework.aspectj.lang.annotation.Log)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        this.handleLog(joinPoint, null, jsonResult);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object jsonResult) {
        try {
            Log controllerLog = this.getAnnotationLog(joinPoint);
            if (controllerLog == null) {
                return;
            }
            User currentUser = ShiroUtils.getSysUser();
            OperLog operLog = new OperLog();
            operLog.setStatus(Integer.valueOf(BusinessStatus.SUCCESS.ordinal()));
            String ip = ShiroUtils.getIp();
            operLog.setOperIp(ip);
            if (StringUtils.isNotNull((Object)jsonResult)) {
                operLog.setJsonResult(StringUtils.substring((String)JSONObject.toJSONString((Object)jsonResult), (int)0, (int)2000));
            }
            operLog.setOperUrl(ServletUtils.getRequest().getRequestURI());
            if (currentUser != null) {
                operLog.setOperName(currentUser.getLoginName());
                if (StringUtils.isNotNull((Object)currentUser.getDept()) && StringUtils.isNotEmpty((String)currentUser.getDept().getDeptName())) {
                    operLog.setDeptName(currentUser.getDept().getDeptName());
                }
            }
            if (e != null) {
                operLog.setStatus(Integer.valueOf(BusinessStatus.FAIL.ordinal()));
                operLog.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operLog.setMethod(className + "." + methodName + "()");
            operLog.setRequestMethod(ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(joinPoint, controllerLog, operLog);
            AsyncManager.me().execute(AsyncFactory.recordOper((OperLog)operLog));
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, Log log, OperLog operLog) throws Exception {
        operLog.setBusinessType(Integer.valueOf(log.businessType().ordinal()));
        operLog.setTitle(log.title());
        operLog.setOperatorType(Integer.valueOf(log.operatorType().ordinal()));
        if (log.isSaveRequestData()) {
            this.setRequestValue(joinPoint, operLog);
        }
    }

    private void setRequestValue(JoinPoint joinPoint, OperLog operLog) {
        Map map = ServletUtils.getRequest().getParameterMap();
        if (StringUtils.isNotEmpty((Map)map)) {
            String params = JSONObject.toJSONString((Object)map, (SerializeFilter)this.excludePropertyPreFilter(), (SerializerFeature[])new SerializerFeature[0]);
            operLog.setOperParam(StringUtils.substring((String)params, (int)0, (int)2000));
        } else {
            Object[] args = joinPoint.getArgs();
            if (StringUtils.isNotNull((Object)args)) {
                String params = this.argsArrayToString(joinPoint.getArgs());
                operLog.setOperParam(StringUtils.substring((String)params, (int)0, (int)2000));
            }
        }
    }

    private Log getAnnotationLog(JoinPoint joinPoint) throws Exception {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(Log.class);
        }
        return null;
    }

    public PropertyPreFilters.MySimplePropertyPreFilter excludePropertyPreFilter() {
        return new PropertyPreFilters().addFilter().addExcludes(EXCLUDE_PROPERTIES);
    }

    private String argsArrayToString(Object[] paramsArray) {
        String params = "";
        if (paramsArray != null && paramsArray.length > 0) {
            for (int i = 0; i < paramsArray.length; ++i) {
                if (!StringUtils.isNotNull((Object)paramsArray[i]) || this.isFilterObject(paramsArray[i])) continue;
                String jsonObj = JSONObject.toJSONString((Object)paramsArray[i], (SerializeFilter)this.excludePropertyPreFilter(), (SerializerFeature[])new SerializerFeature[0]);
                params = params + jsonObj.toString() + " ";
            }
        }
        return params.trim();
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iter;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iter2 = collection.iterator();
            if (iter2.hasNext()) {
                return iter2.next() instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iter = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry entry = iter.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

