/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.framework.aspectj;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.security.ShiroUtils;
import com.ruoyi.framework.aspectj.lang.annotation.DataScope;
import com.ruoyi.framework.web.domain.BaseEntity;
import com.ruoyi.project.system.role.domain.Role;
import com.ruoyi.project.system.user.domain.User;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class DataScopeAspect {
    public static final String DATA_SCOPE_ALL = "1";
    public static final String DATA_SCOPE_CUSTOM = "2";
    public static final String DATA_SCOPE_DEPT = "3";
    public static final String DATA_SCOPE_DEPT_AND_CHILD = "4";
    public static final String DATA_SCOPE_SELF = "5";
    public static final String DATA_SCOPE = "dataScope";

    @Pointcut(value="@annotation(com.ruoyi.framework.aspectj.lang.annotation.DataScope)")
    public void dataScopePointCut() {
    }

    @Before(value="dataScopePointCut()")
    public void doBefore(JoinPoint point) throws Throwable {
        this.clearDataScope(point);
        this.handleDataScope(point);
    }

    protected void handleDataScope(JoinPoint joinPoint) {
        DataScope controllerDataScope = this.getAnnotationLog(joinPoint);
        if (controllerDataScope == null) {
            return;
        }
        User currentUser = ShiroUtils.getSysUser();
        if (currentUser != null && !currentUser.isAdmin()) {
            DataScopeAspect.dataScopeFilter((JoinPoint)joinPoint, (User)currentUser, (String)controllerDataScope.deptAlias(), (String)controllerDataScope.userAlias());
        }
    }

    public static void dataScopeFilter(JoinPoint joinPoint, User user, String deptAlias, String userAlias) {
        Object params;
        StringBuilder sqlString = new StringBuilder();
        for (Role role : user.getRoles()) {
            String dataScope = role.getDataScope();
            if ("1".equals(dataScope)) {
                sqlString = new StringBuilder();
                break;
            }
            if ("2".equals(dataScope)) {
                sqlString.append(StringUtils.format((String)" OR {}.dept_id IN ( SELECT dept_id FROM sys_role_dept WHERE role_id = {} ) ", (Object[])new Object[]{deptAlias, role.getRoleId()}));
                continue;
            }
            if ("3".equals(dataScope)) {
                sqlString.append(StringUtils.format((String)" OR {}.dept_id = {} ", (Object[])new Object[]{deptAlias, user.getDeptId()}));
                continue;
            }
            if ("4".equals(dataScope)) {
                sqlString.append(StringUtils.format((String)" OR {}.dept_id IN ( SELECT dept_id FROM sys_dept WHERE dept_id = {} or find_in_set( {} , ancestors ) )", (Object[])new Object[]{deptAlias, user.getDeptId(), user.getDeptId()}));
                continue;
            }
            if (!"5".equals(dataScope)) continue;
            if (StringUtils.isNotBlank((CharSequence)userAlias)) {
                sqlString.append(StringUtils.format((String)" OR {}.user_id = {} ", (Object[])new Object[]{userAlias, user.getUserId()}));
                continue;
            }
            sqlString.append(" OR 1=0 ");
        }
        if (StringUtils.isNotBlank((CharSequence)sqlString.toString()) && StringUtils.isNotNull((Object)(params = joinPoint.getArgs()[0])) && params instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)params;
            baseEntity.getParams().put("dataScope", " AND (" + sqlString.substring(4) + ")");
        }
    }

    private DataScope getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(DataScope.class);
        }
        return null;
    }

    private void clearDataScope(JoinPoint joinPoint) {
        Object params = joinPoint.getArgs()[0];
        if (StringUtils.isNotNull((Object)params) && params instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)params;
            baseEntity.getParams().put("dataScope", "");
        }
    }
}

