/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.utils.IpUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogUtils {
    public static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"sys-error");
    public static final Logger ACCESS_LOG = LoggerFactory.getLogger((String)"sys-access");

    public static void logAccess(HttpServletRequest request) {
        String username = LogUtils.getUsername();
        String jsessionId = request.getRequestedSessionId();
        String ip = IpUtils.getIpAddr((HttpServletRequest)request);
        String accept = request.getHeader("accept");
        String userAgent = request.getHeader("User-Agent");
        String url = request.getRequestURI();
        String params = LogUtils.getParams((HttpServletRequest)request);
        StringBuilder s = new StringBuilder();
        s.append(LogUtils.getBlock((Object)username));
        s.append(LogUtils.getBlock((Object)jsessionId));
        s.append(LogUtils.getBlock((Object)ip));
        s.append(LogUtils.getBlock((Object)accept));
        s.append(LogUtils.getBlock((Object)userAgent));
        s.append(LogUtils.getBlock((Object)url));
        s.append(LogUtils.getBlock((Object)params));
        s.append(LogUtils.getBlock((Object)request.getHeader("Referer")));
        LogUtils.getAccessLog().info(s.toString());
    }

    public static void logError(String message, Throwable e) {
        String username = LogUtils.getUsername();
        StringBuilder s = new StringBuilder();
        s.append(LogUtils.getBlock((Object)"exception"));
        s.append(LogUtils.getBlock((Object)username));
        s.append(LogUtils.getBlock((Object)message));
        ERROR_LOG.error(s.toString(), e);
    }

    public static void logPageError(HttpServletRequest request) {
        String username = LogUtils.getUsername();
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String message = (String)request.getAttribute("javax.servlet.error.message");
        String uri = (String)request.getAttribute("javax.servlet.error.request_uri");
        Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (statusCode == null) {
            statusCode = 0;
        }
        StringBuilder s = new StringBuilder();
        s.append(LogUtils.getBlock((Object)(t == null ? "page" : "exception")));
        s.append(LogUtils.getBlock((Object)username));
        s.append(LogUtils.getBlock((Object)statusCode));
        s.append(LogUtils.getBlock((Object)message));
        s.append(LogUtils.getBlock((Object)IpUtils.getIpAddr((HttpServletRequest)request)));
        s.append(LogUtils.getBlock((Object)uri));
        s.append(LogUtils.getBlock((Object)request.getHeader("Referer")));
        StringWriter sw = new StringWriter();
        while (t != null) {
            t.printStackTrace(new PrintWriter(sw));
            t = t.getCause();
        }
        s.append(LogUtils.getBlock((Object)sw.toString()));
        LogUtils.getErrorLog().error(s.toString());
    }

    public static String getBlock(Object msg) {
        if (msg == null) {
            msg = "";
        }
        return "[" + msg.toString() + "]";
    }

    protected static String getParams(HttpServletRequest request) {
        Map params = request.getParameterMap();
        return JSON.toJSONString((Object)params);
    }

    protected static String getUsername() {
        return (String)SecurityUtils.getSubject().getPrincipal();
    }

    public static Logger getAccessLog() {
        return ACCESS_LOG;
    }

    public static Logger getErrorLog() {
        return ERROR_LOG;
    }
}

