/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookieUtils {
    public static void setCookie(HttpServletResponse response, String name, String value) {
        CookieUtils.setCookie((HttpServletResponse)response, (String)name, (String)value, (int)86400);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String path) {
        CookieUtils.setCookie((HttpServletResponse)response, (String)name, (String)value, (String)path, (int)86400);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge) {
        CookieUtils.setCookie((HttpServletResponse)response, (String)name, (String)value, (String)"/", (int)maxAge);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String path, int maxAge) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        try {
            cookie.setValue(URLEncoder.encode(value, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.addCookie(cookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        return CookieUtils.getCookie((HttpServletRequest)request, null, (String)name, (boolean)false);
    }

    public static String getCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        return CookieUtils.getCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (boolean)true);
    }

    public static String getCookie(HttpServletRequest request, HttpServletResponse response, String name, boolean isRemove) {
        String value = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                try {
                    value = URLDecoder.decode(cookie.getValue(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (!isRemove) continue;
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
        return value;
    }
}

