/*
 * Decompiled with CFR 0.152.
 */
package com.yh.dl.musicDownload;

import com.yh.dl.musicDownload.model.MusicDownload;
import com.yh.dl.musicDownload.service.MusicDownloadService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class task {
    @Autowired
    private MusicDownloadService musicDownloadService;
    @Value(value="${serviceNumber}")
    private Integer serviceNumber;
    @Value(value="${taskSize}")
    private Integer taskSize;
    @Value(value="${serviceType}")
    private String serviceType;

    @Async
    @Scheduled(cron="0/3 * * * * ?")
    public void configureTasks() {
        Long l;
        List list = this.musicDownloadService.getInTransitQueue(this.serviceType);
        if (!list.isEmpty() && (l = this.musicDownloadService.getTransferringAndDepositingCountByServiceNumber(this.serviceNumber)) < (long)this.taskSize.intValue()) {
            this.musicDownloadService.processBuilder((MusicDownload)list.get(0), this.serviceNumber);
        }
    }

    @Async
    @Scheduled(cron="0/600 * * * * ?")
    public void deleteDataTasks() {
        if (this.serviceNumber != null && this.serviceNumber != 1) {
            List list = this.musicDownloadService.getDeleteData(this.serviceNumber);
            for (MusicDownload m : list) {
                this.musicDownloadService.deleteDataGQ(m);
            }
        }
    }

    @Async
    @Scheduled(cron="0 1 0 * * ?", zone="Asia/Shanghai")
    public void mdTasks() {
        if (this.serviceNumber != null && this.serviceNumber == 1) {
            List vipUserList = this.musicDownloadService.getUIdsIsVIP();
            for (Map uMap : vipUserList) {
                Long id = (Long)uMap.get("id");
                Integer num = this.musicDownloadService.getUserRemainingTransferQuantityByID(id);
                if ((Long)uMap.get("group_users") == 7L) {
                    if (num < 50 && (num = Integer.valueOf(num + 5)) > 50) {
                        num = 50;
                    }
                } else if ((Long)uMap.get("group_users") == 9L) {
                    if (num < 50) {
                        num = num + 1;
                    }
                } else if ((Long)uMap.get("group_users") == 8L) {
                    if (num < 50 && (num = Integer.valueOf(num + 2)) > 50) {
                        num = 50;
                    }
                } else if ((Long)uMap.get("group_users") == 6L && num < 50 && (num = Integer.valueOf(num + 2)) > 50) {
                    num = 50;
                }
                this.musicDownloadService.addDLNum(id, num);
            }
        }
    }

    @Async
    @Scheduled(cron="0/60 * * * * ?")
    public void orderTask() {
        if (this.serviceNumber != null && this.serviceNumber == 1) {
            List ids = this.musicDownloadService.getUIdByOrder();
            for (Long i : ids) {
                Integer num = this.musicDownloadService.getUserRemainingTransferQuantityByID(i);
                if (num >= 7) continue;
                this.musicDownloadService.addDLNum(i, Integer.valueOf(7));
            }
        }
    }

    @Async
    @Scheduled(cron="0/600 * * * * ?")
    public void orderTimeOutTask() {
        if (this.serviceNumber != null && this.serviceNumber == 1) {
            this.musicDownloadService.upDateTimeOutTask();
        }
    }
}

