/*
 * Decompiled with CFR 0.152.
 */
package com.yh.dl.musicDownload.service;

import com.yh.dl.musicDownload.model.SearchDTO;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Exception performing whole class analysis ignored.
 */
public class QobuzSearchService {
    private static final String BASE_URL = "https://www.qobuz.com";
    private static final String ALBUM_CARD_SELECTOR = "div.ReleaseCard";
    private static final String ALBUM_TITLE_LINK_SELECTOR = "a.ReleaseCardInfosTitle";
    private static final String COVER_IMAGE_SELECTOR = "img.CoverModel";
    private static final String INFO_TEXT_SELECTOR = ".CoverModelDataDefault.ReleaseCardActionsText";
    private static final Pattern TRACK_COUNT_PATTERN = Pattern.compile("(\\d+)\\s*(?:piste|pistes|track|tracks)", 2);
    private static final DateTimeFormatter[] DATE_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("d MMM yyyy"), DateTimeFormatter.ofPattern("d MMM. yyyy"), DateTimeFormatter.ofPattern("d LLLL yyyy")};

    public static List<SearchDTO> searchAlbums(String query, String regionCode, String platformName) throws IOException {
        if (query == null || query.isEmpty() || regionCode == null || regionCode.isEmpty()) {
            if (platformName == null || !platformName.equalsIgnoreCase("Qobuz")) {
                throw new IllegalArgumentException("Platform must be 'Qobuz'. Current value: " + platformName);
            }
            throw new IllegalArgumentException("Query and Region Code cannot be null or empty.");
        }
        String url = QobuzSearchService.buildSearchUrl((String)query, (String)regionCode);
        String htmlContent = QobuzSearchService.fetchHtmlContent((String)url, (String)regionCode);
        if (htmlContent == null || htmlContent.isEmpty()) {
            System.err.println("Failed to fetch HTML content from: " + url);
            return new ArrayList<SearchDTO>();
        }
        return QobuzSearchService.parseHtmlToSearchDTOs((String)htmlContent, (String)regionCode);
    }

    private static String buildSearchUrl(String query, String regionCode) {
        String encodedQuery;
        try {
            encodedQuery = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        encodedQuery = encodedQuery.replace("+", "%20");
        return "https://www.qobuz.com/" + regionCode + "/search/albums/" + encodedQuery;
    }

    private static String fetchHtmlContent(String url, String regionCode) throws IOException {
        String languageCode = regionCode.split("-")[0];
        try {
            Document doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7").header("Accept-Language", languageCode + ";q=0.9,en;q=0.8").header("Accept-Encoding", "gzip, deflate, br, zstd").header("Connection", "keep-alive").header("Upgrade-Insecure-Requests", "1").header("Referer", "https://www.qobuz.com/" + regionCode + "/").timeout(10000).get();
            return doc.html();
        }
        catch (IOException e) {
            System.err.println("Error fetching URL: " + url + ", Error: " + e.getMessage());
            throw e;
        }
    }

    private static List<SearchDTO> parseHtmlToSearchDTOs(String htmlContent, String regionCode) {
        ArrayList<SearchDTO> albums = new ArrayList<SearchDTO>();
        Document doc = Jsoup.parse((String)htmlContent);
        Elements albumCards = doc.select("div.ReleaseCard");
        String artistLinkSelector = "a[href^='/" + regionCode + "/interpreter']";
        for (Element card : albumCards) {
            String url;
            String[] parts;
            Element coverImg;
            Element artistLink;
            SearchDTO album = new SearchDTO();
            Element titleLink = card.selectFirst("a.ReleaseCardInfosTitle");
            if (titleLink != null) {
                album.setName(titleLink.text());
                String href = titleLink.attr("href");
                album.setAlbumUrl("https://www.qobuz.com" + href);
            }
            if ((artistLink = card.selectFirst(artistLinkSelector)) != null) {
                album.setArtist(artistLink.text());
            }
            if ((coverImg = card.selectFirst("img.CoverModel")) != null) {
                String imageUrl = coverImg.attr("data-src");
                if (imageUrl.isEmpty()) {
                    imageUrl = coverImg.attr("src");
                }
                album.setCoverUrl(imageUrl);
            }
            Elements infoElements = card.select(".CoverModelDataDefault.ReleaseCardActionsText");
            for (Element infoElement : infoElements) {
                String text = infoElement.text().trim();
                Matcher trackMatcher = TRACK_COUNT_PATTERN.matcher(text);
                if (trackMatcher.find()) {
                    String trackCountString = trackMatcher.group(0);
                    album.setTrackCount(trackCountString);
                    continue;
                }
                LocalDate parsedDate = QobuzSearchService.parseFrenchDate((String)text);
                if (parsedDate == null) continue;
                String fullDateString = parsedDate.toString();
                album.setReleaseDate(fullDateString);
                String year = String.valueOf(parsedDate.getYear());
                album.setReleaseYear(year);
            }
            Element hiResIcon = card.selectFirst("svg[class*='ReleaseCardQualityIcon'] title");
            if (hiResIcon != null) {
                String titleText = hiResIcon.text();
                if (titleText.toLowerCase().contains("hi-res") || titleText.toLowerCase().contains("24-bit")) {
                    album.setFormat("Hi-Res 24-Bit");
                } else {
                    album.setFormat(titleText);
                }
            } else {
                album.setFormat("Standard");
            }
            if (album.getAlbumUrl() != null && (parts = (url = album.getAlbumUrl()).split("/")).length > 0) {
                String lastPart = parts[parts.length - 1];
                if (!lastPart.isEmpty() && !lastPart.equals("-")) {
                    album.setId(lastPart);
                } else if (parts.length > 1) {
                    String secondLastPart = parts[parts.length - 2];
                    if (!secondLastPart.isEmpty() && secondLastPart.startsWith("0")) {
                        album.setId(secondLastPart);
                    } else {
                        album.setId(lastPart);
                    }
                } else {
                    album.setId(lastPart);
                }
            }
            albums.add(album);
        }
        return albums;
    }

    private static LocalDate parseFrenchDate(String dateString) {
        String[] frenchMonths = new String[]{"janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre"};
        String[] frenchMonthShorts = new String[]{"janv.", "f\u00e9vr.", "mars", "avr.", "mai", "juin", "juil.", "ao\u00fbt", "sept.", "oct.", "nov.", "d\u00e9c."};
        String input = dateString.trim().toLowerCase();
        for (DateTimeFormatter formatter : DATE_FORMATTERS) {
            try {
                int i;
                String normalizedInput;
                String[] parts;
                int i2;
                for (i2 = 0; i2 < frenchMonths.length; ++i2) {
                    String month = frenchMonths[i2];
                    if (!input.contains(month) || (parts = (normalizedInput = input.replace(month, String.format("%02d", i2 + 1))).split("\\s+")).length != 3) continue;
                    String day = parts[0];
                    String monthNum = parts[1];
                    String year = parts[2];
                    String recombined = String.format("%s %s %s", day, month, year);
                    return LocalDate.parse(recombined, formatter);
                }
                for (i2 = 0; i2 < frenchMonthShorts.length; ++i2) {
                    String monthShort = frenchMonthShorts[i2];
                    if (!input.contains(monthShort) || (parts = (normalizedInput = input.replace(monthShort, String.format("%02d", i2 + 1))).split("\\s+")).length != 3) continue;
                    String day = parts[0];
                    String monthNum = parts[1];
                    String year = parts[2];
                    String recombined = String.format("%s %s %s", day, monthShort, year);
                    return LocalDate.parse(recombined, formatter);
                }
                String normalizedForParsing = input;
                for (i = 0; i < frenchMonths.length; ++i) {
                    normalizedForParsing = normalizedForParsing.replace(frenchMonths[i], String.format("%02d", i + 1));
                }
                for (i = 0; i < frenchMonthShorts.length; ++i) {
                    normalizedForParsing = normalizedForParsing.replace(frenchMonthShorts[i], String.format("%02d", i + 1));
                }
                String[] normParts = normalizedForParsing.split("\\s+");
                if (normParts.length != 3) continue;
                String day = normParts[0];
                String monthNumStr = normParts[1].replace(".", "");
                String year = normParts[2];
                String paddedMonth = String.format("%02d", Integer.parseInt(monthNumStr));
                String standardFormat = String.format("%s %s %s", day, paddedMonth, year);
                DateTimeFormatter numericFormatter = DateTimeFormatter.ofPattern("d MM yyyy");
                return LocalDate.parse(standardFormat, numericFormatter);
            }
            catch (DateTimeParseException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String query = "jay";
        String regionCode = "fr-fr";
        String platformName = "Qobuz";
        try {
            List results = QobuzSearchService.searchAlbums((String)query, (String)regionCode, (String)platformName);
            System.out.println("Search Results for '" + query + "' on platform '" + platformName + "' in region '" + regionCode + "':");
            System.out.println("Found " + results.size() + " albums:");
            for (SearchDTO album : results) {
                System.out.println("ID: " + album.getId() + ", Name: " + album.getName() + ", Artist: " + album.getArtist() + ", Year: " + album.getReleaseYear() + ", Tracks: " + album.getTrackCount() + ", Format: " + album.getFormat() + ", URL: " + album.getAlbumUrl());
            }
        }
        catch (IOException e) {
            System.err.println("An error occurred during the search: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

